module vga(
   input  wire  clk,
   input  wire  aRST,
   output wire vga_nrst,
   // Interface
   output logic [10:0] x,
   output logic [9:0] y,
   input  logic [7:0] r ,
   input  logic [7:0] g ,
   input  logic [7:0] b ,
   output logic eof,
   // signaux vga extérieurs
   output logic vga_hs,
   output logic vga_vs,
   output logic vga_clk,
   output logic vga_blank_n,
   output logic vga_sync_n,
   output logic [7:0] vga_r,
   output logic [7:0] vga_g,
   output logic [7:0] vga_b
);

// PLL to generate the vga clock
// the vga counters are reseted till it is locked
vga_pll vga_pll_i(
   .refclk   ( clk     ) ,
   .rst      ( aRST    ) ,
   .outclk_0 ( vga_clk ) ,
   .locked   ( vga_nrst    )
);

// parameters for a 1280x1024 VESA image @60Hz
// the pixel clock frequency should be 108MHz
parameter HBP    = 248;
parameter HDISP  = 1280;
parameter HFP    = 48;
parameter HPULSE = 112;

parameter VBP    = 38;
parameter VDISP  = 1024;
parameter VFP    = 1;
parameter VPULSE = 3;

localparam WIDTH  = HBP + HDISP + HFP + HPULSE;
localparam HEIGHT = VBP + VDISP + VFP + VPULSE;
localparam HDEPTH = $clog2(WIDTH);
localparam VDEPTH = $clog2(HEIGHT);

logic [HDEPTH-1:0] cpt_h;
logic [VDEPTH-1:0] cpt_v;

always_ff@(posedge vga_clk)
   if(vga_nrst == 0)
   begin
      cpt_h <= '0;
      cpt_v <= '0;
   end
   else
   begin
      cpt_h <= cpt_h + 1'b1;
      if (cpt_h == WIDTH-1)
      begin
         cpt_h <= '0;
         cpt_v <= cpt_v + 1'b1;
         if (cpt_v == HEIGHT-1)
            cpt_v <= '0;
      end
   end

// not used
assign vga_sync_n = 0;

always_ff@(posedge vga_clk)
begin
   vga_blank_n <= (cpt_h < HDISP) && (cpt_v < VDISP);
   vga_hs      <= (cpt_h < HDISP+HFP) || (cpt_h >= HDISP+HFP+HPULSE);
   vga_vs      <= (cpt_v < VDISP+VFP) || (cpt_v >= VDISP+VFP+VPULSE);
end

// eof est généré au début de la zone de noir
assign eof = (cpt_h == HDISP) && (cpt_v == VDISP);

// Les coordonnées dans l'image
// l'origine est dans le coin supérieur gauche
assign x = cpt_h[10:0];
assign y = cpt_v[9:0];


assign vga_r = r;
assign vga_g = g;
assign vga_b = b;

endmodule
