module reset_gen (
      key,
      clock,
      reset,
      nreset
      );

input wire key;
input wire clock;
output reset;
output nreset;

wire async_nreset = key;

// Resynchronisation du reset sur l'horloge
// Les attributs de synthèse servent à enmpêcher l'optimisation
logic reset   /* synthesis ALTERA_ATTRIBUTE = "{-from \"*\"} CUT=ON ; PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101"  */ ;
logic reset_r /* synthesis ALTERA_ATTRIBUTE = "PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101"  */; 
logic nreset   /* synthesis ALTERA_ATTRIBUTE = "{-from \"*\"} CUT=ON ; PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101"  */ ;
logic nreset_r /* synthesis ALTERA_ATTRIBUTE = "PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101"  */; 

// reset positif
always @(posedge clock or negedge async_nreset)
if (!async_nreset)
begin
  reset_r <= 1'b1;
  reset   <= 1'b1 ;
end
else
begin
  reset_r <= 1'b0 ;
  reset   <= reset_r ;
end

// reset negatif
always @(posedge clock or negedge async_nreset)
if (!async_nreset)
begin
  nreset_r <= 1'b0;
  nreset   <= 1'b0 ;
end
else
begin
  nreset_r <= 1'b1 ;
  nreset   <= nreset_r ;
end

endmodule
