// --------------------------------------------------------------------
// Copyright (c) 2005 by Terasic Technologies Inc.
// --------------------------------------------------------------------
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altrea Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL or Verilog source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// --------------------------------------------------------------------
//
//                     Terasic Technologies Inc
//                     356 Fu-Shin E. Rd Sec. 1. JhuBei City,
//                     HsinChu County, Taiwan
//                     302
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// --------------------------------------------------------------------
//
// Major Functions:i2c controller
//
// --------------------------------------------------------------------
//
// Revision History :
// --------------------------------------------------------------------
//   Ver  :| Author            :| Mod. Date :| Changes Made:
//   V1.0 :| Joe Yang          :| 05/07/10  :|      Initial Revision
// --------------------------------------------------------------------
module i2c (
	clock,
	i2c_iclk,
   en,
	i2c_sclk,//I2C clock
 	i2c_sdat,//I2C DATA
	i2c_data,//DATA:[SLAVE_ADDR,SUB_ADDR,DATA]
	go,      //go transfert
   done,     //end of transfert
	// W_R,  //W_R
	ack,      //ack
`ifdef TEST_I2C
   sd_counter,
	sdo,
`endif
	nreset
);
	input  clock;
	input  i2c_iclk;
    input  en;
	input  [23:0]i2c_data;
	input  go;
	input  nreset;
	// input  W_R;
 	inout  i2c_sdat;
	output i2c_sclk;
	output done;
	output ack;

`ifdef TEST_I2C
	output [5:0] sd_counter;
	output sdo;
`endif


reg sdo;
reg sclk;
reg done;
reg [23:0]SD;
reg [5:0]sd_counter;



reg ack1,ack2,ack3;
wire ack=ack1 | ack2 |ack3;

//--I2C COUNTER
always @(negedge nreset or posedge clock ) begin
if (!nreset)
   sd_counter <= 6'b111111;
else begin
if (go==0)
	sd_counter <= 0;
	else if (en)
    begin
        if (sd_counter < 6'b111111) sd_counter <= sd_counter+1'b1;
    end
end
end
//----

always @(negedge nreset or  posedge clock ) begin
   if (!nreset) begin
      sclk <= 1;
      sdo  <= 1;
      ack1 <= 0;
      ack2 <= 0;
      ack3 <= 0;
      done  <= 1;
   end
   else
      if (en)
         case (sd_counter)
            6'd0  : begin
               ack1       <= 0 ;
               ack2       <= 0 ;
               ack3       <= 0 ;
               done        <= 0;
               sdo        <= 1;
               sclk       <= 1;
            end
            //start
            6'd1  : begin
               SD  <= i2c_data;
               sdo <= 0;
            end
            6'd2  : sclk <= 0;
            //SLAVE ADDR
            6'd3  : sdo <= SD[23];
            6'd4  : sdo <= SD[22];
            6'd5  : sdo <= SD[21];
            6'd6  : sdo <= SD[20];
            6'd7  : sdo <= SD[19];
            6'd8  : sdo <= SD[18];
            6'd9  : sdo <= SD[17];
            6'd10 : sdo <= SD[16];
            6'd11 : sdo <= 1'b1;//ack

            //SUB ADDR
            6'd12  : begin 
               sdo  <= SD[15];
               ack1 <= i2c_sdat;
            end
            6'd13  : sdo <= SD[14];
            6'd14  : sdo <= SD[13];
            6'd15  : sdo <= SD[12];
            6'd16  : sdo <= SD[11];
            6'd17  : sdo <= SD[10];
            6'd18  : sdo <= SD[9];
            6'd19  : sdo <= SD[8];
            6'd20  : sdo <= 1'b1;//ack

            //DATA
            6'd21  : begin
               sdo  <= SD[7];
               ack2 <= i2c_sdat;
            end
            6'd22  : sdo <= SD[6];
            6'd23  : sdo <= SD[5];
            6'd24  : sdo <= SD[4];
            6'd25  : sdo <= SD[3];
            6'd26  : sdo <= SD[2];
            6'd27  : sdo <= SD[1];
            6'd28  : sdo <= SD[0];
            6'd29  : sdo <= 1'b1;//ack


            //stop
            6'd30 : begin
               sdo  <= 1'b0;
               sclk <= 1'b0;
               ack3 <= i2c_sdat;
            end
            6'd31 : sclk <= 1'b1;
            6'd32 : begin
               sdo <= 1'b1;
               done <= 1;
            end
            default:begin
               // nothing to do
            end
         endcase
end

// outputs
wire i2c_sdat = sdo? 1'bz : 1'b0 ;

reg i2c_sclk;

always @(posedge clock )
    i2c_sclk <= sclk | ( ((sd_counter >= 4) & (sd_counter <= 30))? ~i2c_iclk:1'b0 );

endmodule
