module draw_unit(    input logic clk,
            input logic nrst,
            input logic next_maze,
            // Interface video
            input  logic [10:0] vga_x,
            input  logic [9:0] vga_y,
            output logic [7:0] r ,
            output logic [7:0] g ,
            output logic [7:0] b ,
            input  logic eof,
            // contrôle de la souris
            output logic clk_div,
				input  logic turbo,
            input  logic forward,
            input  logic rotate_r,
            input  logic rotate_l,
            output logic hit_left,
            output logic hit_right

            );

   parameter image_W   = 1280;
   parameter image_H   = 1024;

   // on se limite à  une zone de 1024x1024
   localparam DRAW_ZONE  = 1024;
   localparam DRAW_WIDTH = $clog2(DRAW_ZONE);
   localparam T_border = (image_H -DRAW_ZONE)/2;
   localparam B_border = (image_H -DRAW_ZONE)/2;
   localparam L_border = (image_W -DRAW_ZONE)/2;
   localparam R_border = (image_W -DRAW_ZONE)/2;
   localparam SQUARE_W = 128; // Taille d'un carré de la grille
   localparam SQR_W_WIDTH = $clog2(SQUARE_W);
   localparam LAST_SQR = DRAW_ZONE/SQUARE_W -1; //Le dernier carré de la grille
   localparam SPRITE_W = 32; // taille du sprite de la souris
   localparam SHIFT_W  = 8; // déplacement



   // Diviseur d'horloge, les déplacements de la souris ne se feront qu'à  cette
   // cadence
   // clk_div_en passe à 1 en mm temps que le front montant de clk_div qui est
   // utilisée dans le module mouse
   logic                  clk_div_en;
   integer                clk_div_cpt;
   localparam DIV_MAX   = 4*(2**21);
	localparam DIV_MAX_T = 4*(2**18);

   always@(posedge clk)
      if (nrst == 0)
         clk_div_cpt <= turbo? (DIV_MAX_T -1):(DIV_MAX -1);
      else
      begin
         clk_div_en <= 0;
         clk_div_cpt <= clk_div_cpt - 1;
         if (clk_div_cpt == 0)
         begin
            clk_div_en <= 1;
            clk_div_cpt <= turbo? (DIV_MAX_T -1):(DIV_MAX -1);
         end
         clk_div <= (clk_div_cpt < (turbo? DIV_MAX_T/2 : DIV_MAX/2));
      end



   // La grille du labyrinthe
   // Seules les bordures sup et gauche
   // 1 si bordure 0 sinon
   logic [0:7][0:7][0:1] maze_t[0:31] ;
   logic [0:7][0:7][0:1] maze ;
   // La case à  atteindre
   logic [1:0][2:0]      target_t[0:31] ;
   logic [1:0][2:0]      target ;

   initial
     begin
    $readmemb("maze_walls.vh",maze_t);
    $readmemb("maze_last.vh",target_t);
     end

   // TODO choisir aléatoirement l'une des cartes
   logic[4:0] maze_sel_cpt;

   always@(posedge clk)
     if (nrst == 0)
       maze_sel_cpt <= '0;
     else if (next_maze)
       maze_sel_cpt <= maze_sel_cpt +1;

   // Pour éviter le scintillement ne changer de carte qu'à  la fin
   // d'une trame
   always@(posedge clk)
     if (eof) begin
    maze   <= maze_t  [maze_sel_cpt];
    target <= target_t[maze_sel_cpt];
     end


   // Le coin sup gauche de la souris
   logic [DRAW_WIDTH-1:0] X_s,Y_s;
   // Son orientation (16 orientations possibles)
   logic [3:0] O_s;
   // avons nous atteint la cible
   logic       target_reached;

   // Position de la souris
   always_ff @(posedge clk)
   begin: mous_pos
   // La nouvelle position
   logic [DRAW_WIDTH-1:0] nX_s,nY_s;
   // La position du sommet
   logic [DRAW_WIDTH-1:0] hX_s,hY_s;
   logic [DRAW_WIDTH-1:0] nhX_s,nhY_s;
   // Position dans la grille
   logic [2:0] case_sx,case_sy;
   logic [2:0] case_sxn,case_syn;
     // Si on change de carte on se remet aussi à  la position initiale
     if (nrst == 0 || next_maze)
       begin
          // au centre de la 1e case (en haut à  gauche)
          X_s  <= (SQUARE_W - SPRITE_W)/2;
          Y_s  <= (SQUARE_W - SPRITE_W)/2;
          // initialement vers le bas
          O_s  <= '0;
          hit_left <= 0;
          hit_right<= 0;
          target_reached <= 0;
       end
     else
       begin

      // Position du centre du sprite dans la grille
      case_sx  = 3'((X_s + SPRITE_W/2)/SQUARE_W);
      case_sy  = 3'((Y_s + SPRITE_W/2)/SQUARE_W);
      // On est arrivé à  la dernière case
      if (case_sx==target[0] && case_sy==target[1]) target_reached <= 1;

      // la reference est le coins sup gauche
      nX_s = X_s;
      nY_s = Y_s;

      // on fait comme si on pouvait se déplacer 
      // En fonction de l'orientation plusieurs cas
      // Verticalement
      case(O_s)
         // vers le bas
         4'd0,
         // diagonale gauche/bas
         4'd1,4'd2,4'd3,
         // diagonale droite/bas
         4'd13,4'd14,4'd15: begin
            nY_s  = Y_s  + SHIFT_W;
            hY_s  = Y_s  + SPRITE_W -1;
            nhY_s = nY_s + SPRITE_W -1;
         end
         // vers le haut
         4'd8,
         // diagonale gauche/haut
         4'd5,4'd6,4'd7,
         // diagonale droite/haut
         4'd9,4'd10,4'd11: begin
            nY_s  = Y_s  - SHIFT_W;
            hY_s  = Y_s ;
            nhY_s = nY_s;
         end
         // vers la gauche
         4'd4,
         // vers la droite
         4'd12: begin
            nY_s  = Y_s;
            hY_s  = Y_s ;
            nhY_s = nY_s;
         end
      endcase

      // Horizontalement
      case(O_s)
         // vers la gauche
         4'd4,
         // diagonale gauche/bas
         4'd1,4'd2,4'd3,
         // diagonale gauche/haut
         4'd5,4'd6,4'd7: begin
            nX_s  = X_s - SHIFT_W;
            hX_s  = X_s;
            nhX_s = nX_s;
         end
         // vers la droite
         4'd12,
         // diagonale droite/haut
         4'd9,4'd10,4'd11,
         // diagonale droite/bas
         4'd13,4'd14,4'd15: begin
            nX_s  = X_s  + SHIFT_W;
            hX_s  = X_s  + SPRITE_W -1;
            nhX_s = nX_s + SPRITE_W -1;
         end
         // vers le haut
         4'd8,
         // vers le bas
         4'd0: begin
            nX_s  = X_s;
            hX_s  = X_s;
            nhX_s = nX_s;
         end
      endcase

       // On vérifie si on touche
       hit_left <= 0;
       hit_right<= 0;
      // dans quelle sommes nous?
      case_sx  = 3'(hX_s/SQUARE_W);
      case_sy  = 3'(hY_s/SQUARE_W);
      // dans quelle case serions nous?
      case_sxn = 3'(nhX_s/SQUARE_W);
      case_syn = 3'(nhY_s/SQUARE_W);

      // traverserait-on un mur?
      // on est allé à  droite et on a traversé un mur
      if (( case_sxn == case_sx + 3'd1 && maze[case_sy][case_sxn][0]) || (case_sx == 3'(LAST_SQR) && case_sxn == 0))
      begin
         // on annule le mouvement
         nX_s = X_s;
         nY_s = Y_s;
         // a-t-on touché
         hit_right <= ( O_s >= 9   && O_s <= 12) ;
         hit_left  <= ( O_s <= 15  && O_s >= 12);
      end
      // on est allé à  gauche et on a traversé un mur
      if ((case_sxn == case_sx -1  && maze[case_sy][case_sx][0]) || (case_sx == 0 && case_sxn == 3'(LAST_SQR)))
      begin
         // on annule le mouvement
         nX_s = X_s;
         nY_s = Y_s;
         // a-t-on touché
         hit_right <= ( O_s >= 1   && O_s <= 4) ;
         hit_left  <= ( O_s <= 7   && O_s >= 4);
      end
      // on est allé en bas   et on a traversé un mur
      if ((case_syn == case_sy+1  && maze[case_syn][case_sx][1]) || (case_sy == 3'(LAST_SQR) && case_syn == 0))
      begin
         // on annule le mouvement
         nX_s = X_s;
         nY_s = Y_s;
         // a-t-on touché
         hit_right <= ( O_s >= 13  && O_s <= 15) || O_s == 0 ;
         hit_left  <= ( O_s >= 0   && O_s <=  3);
      end
      // on est allé en haut  et on a traversé un mur
      if (( case_syn == case_sy-1 && maze[case_sy][case_sx][1]) || (case_sy == 0 && case_syn == 3'(LAST_SQR)))
      begin
         // on annule le mouvement
         nX_s = X_s;
         nY_s = Y_s;
         // a-t-on touché
         hit_right <= ( O_s <= 8   && O_s >= 5 );
         hit_left  <= ( O_s >= 8   && O_s <= 11) ;
      end

      // TODO: On touche les bordures d'une case mais on est // à  la paroie
      // je ne sais pas si c'est vraiment utile


      ////////////////////////////////////////////////////////////////////////////////
      ////// On se déplce vraiment        ////////////////////////////////////////////
      ////////////////////////////////////////////////////////////////////////////////
         // Déplacement tant qu'on a pas atteint la cible
      if(clk_div_en && !target_reached)
        begin
          // On met à  jour la position si on nous demande d'avancer
          if (forward) begin
             X_s <= nX_s;
             Y_s <= nY_s;
          end
          // On tourne mĂȘme si on avance pas
          O_s <= O_s + rotate_l - rotate_r;
       end
    end
   end

   // Pour éviter les scintillements, on recopie les positions en fin d'une trame
   logic [DRAW_WIDTH-1:0] X_disp,Y_disp;
   logic [3:0] O_disp;

   always_ff @(posedge clk)
      if(eof)
      begin
         X_disp <= X_s;
         Y_disp <= Y_s;
         O_disp <= O_s;
      end

   // sprites (4 images)
   logic [7:0] sprite_rom [0:4*SPRITE_W**2 -1];
   logic [7:0] sprite_color ;
   logic [11:0] sprite_adr;

   // adresse dans le sprite
   // Il n'y a que 4 images, les 12 autres sont obtenues par symétrie
   always_comb
     begin:sprite_addr
    logic [4:0] l,c;
    l = 5'(y - Y_disp);
    c = 5'(x - X_disp);
    if (O_disp<4)
      sprite_adr = {O_disp[1:0],5'd31-l,5'd31-c};
    else if (O_disp<8)
      sprite_adr = {O_disp[1:0],c,5'd31-l};
    else if (O_disp<12)
      sprite_adr = {O_disp[1:0],l,c};
    else
      sprite_adr = {O_disp[1:0],5'd31-c,l};
     end

   // ROM des sprites de la souris
   initial
     $readmemh("sprite.vh",sprite_rom);

   always_ff@(posedge clk)
     begin
       sprite_color <= sprite_rom[sprite_adr];
     end


   // se ramener aux coordonnées d'un carré centré de 1024x1024
   logic [DRAW_WIDTH-1:0] x,y;
   logic       border;
   always_comb
     begin
    border = 0;
    x = DRAW_WIDTH'(vga_x - L_border);
    y = DRAW_WIDTH'(vga_y - B_border);
    if (vga_x<L_border || vga_x >=image_W-R_border
        || vga_y<B_border || vga_y >=image_H-T_border) begin
       border = 1;
    end
     end

   // sprite de la case cible
   logic [23:0] target_rom [0:SQUARE_W*SQUARE_W-1];
   logic [23:0] target_color;
   initial
     $readmemh("cheese.vh",target_rom);

   always_ff@(posedge clk)
     begin
      logic [SQR_W_WIDTH-1:0] l,c;
      l = SQR_W_WIDTH'(y%SQUARE_W);
      c = SQR_W_WIDTH'(x%SQUARE_W);
      target_color <= target_rom[{l,c}];
     end

   logic [23:0] back_rom [0:64*64-1];
   logic [23:0] back_color;
   initial
     $readmemh("wall.vh",back_rom);

   always_ff@(posedge clk)
     begin
      logic [5:0] l,c;
      l = y[5:0];
      c = x[5:0];
      back_color <= back_rom[{l,c}];
     end

     // composition
     always_ff @(posedge clk)
     begin: composition
        logic [2:0] case_x, case_y;
        if (nrst == 0)
        begin
           r <= '0;
           g <= '0;
           b <= '0;
        end
        else
        begin
           case_x = 3'(x/SQUARE_W);
           case_y = 3'(y/SQUARE_W);
           // fond
           r <= 'hff;
           g <= 'ha1;
           b <= 'h57;
           // premiere case (toujours 0)
           if (case_x==0 && case_y==0)
           begin
              r <= '0;
              g <= 128;
              b <= '0;
           end
           // derniere case du parcours
           if (case_x==target[0] && case_y==target[1])
           begin
              r <= (target_reached)?clk_div*128:200;
              g <= (target_reached)?clk_div*128:'0;
              b <= '0;
              if (target_color != 24'hffffff) begin
                 r <= target_color[7:0];
                 g <= target_color[15:8];
                 b <= target_color[23:16];
              end
           end
           // colonnes du Labyrinthe
           if (x%SQUARE_W == 0) begin
              if (maze[case_y][case_x][0])
              begin
                 r <= '1;
                 g <= '1;
                 b <= '1;
              end
           end
           // ligines du Labyrinthe
           if (y%SQUARE_W == 0) begin
              if (maze[case_y][case_x][1])
              begin
                 r <= '1;
                 g <= '1;
                 b <= '1;
              end
           end
           // dans la souris
           if ((x > X_disp) && (x<X_disp+SPRITE_W) &&(y> Y_disp) && (y<Y_disp+SPRITE_W))
           begin
              // si ce n'est pas le fond (blanc!)
              // la souris est grise
              if (sprite_color != 8'hff)
              begin
              {r,g,b} <= {3{sprite_color}};
              if (sprite_color == 8'd200)
              begin
              {r,g,b} <= '0;
              if (hit_right)
              {r,g,b} <= {8'h00,8'hff,8'h00};
              end
              if (sprite_color == 8'd230)
              begin
              {r,g,b} <= '0;
              if (hit_left)
              {r,g,b} <= {8'hff,8'h00,8'h00};
              end
              end
           end

           // bordure
           if (border) begin
              r <= back_color[7:0] ;
              g <= back_color[15:8] ;
              b <= back_color[23:16] ;
           end
        end
     end

endmodule
