`default_nettype none

module DE1_SoC(

      ///////// AUD /////////
      input  wire        aud_adcdat,
      inout  wire        aud_adclrck,
      inout  wire        aud_bclk,
      output logic       aud_dacdat,
      inout  wire        aud_daclrck,
      output logic       aud_xck,

      ///////// CLOCK /////////
      input  wire        clock_50,

      ///////// FPGA I2C ////
      output logic       fpga_i2c_sclk,
      inout  wire        fpga_i2c_sdat,

      ///////// GPIO /////////
      inout  wire [35:0] gpio_0,
      inout  wire [35:0] gpio_1,


      ///////// hex0 /////////
      output logic[6:0]  hex0,

      ///////// hex1 /////////
      output logic[6:0]  hex1,

      ///////// hex2 /////////
      output logic[6:0]  hex2,

      ///////// hex3 /////////
      output logic[6:0]  hex3,

      ///////// hex4 /////////
      output logic[6:0]  hex4,

      ///////// hex5 /////////
      output logic[6:0]  hex5,


      ///////// key /////////
      input  wire [3:0]  key,

      ///////// ledr /////////
      output logic[9:0]  ledr,

      ///////// sw /////////
      input  wire [9:0]  sw,

      ///////// VGA /////////
      output logic[7:0]  vga_b,
      output logic       vga_blank_n,
      output logic       vga_clk,
      output logic[7:0]  vga_g,
      output logic       vga_hs,
      output logic[7:0]  vga_r,
      output logic       vga_sync_n,
      output logic       vga_vs
);


wire dummy = &{sw,key};

//    7 seg    //////////////////////////////////////////////////////
assign    hex0        =    sw[0] ? 7'b100_0010 : 7'h7F; // go
assign    hex1        =    sw[1] ? 7'b000_0111 : 7'h7F; // turbo
assign    hex2        =    dummy? 7'h00 : 7'h7F;
assign    hex3        =    dummy? 7'h00 : 7'h7F;
assign    hex4        =    dummy? 7'h00 : 7'h7F;
assign    hex5        =    dummy? 7'h00 : 7'h7F;

// Reset pour du systeme utilisant key[0]
logic reset, nreset;

reset_gen reset_gen_i
         (//
            .key    ( key[0]   ) ,
            .clock  ( clock_50 ) ,
            .reset  ( reset    ) ,
            .nreset ( nreset   )
         );

logic [24:0] C;

always_ff@(posedge clock_50)
   if(reset)
   begin
      ledr <= 10'b0000000001;
      C    <= 0;
   end
   else
   begin
      C <= C + 1;
      if(C[24])
      begin
         C <= '0;
         ledr <= {ledr[0],ledr[9:1]};
      end
   end

//////////////////////////////////////////////////////////////////////
// Module pour la gestion du    //////////////////////////////////////
// codec audio                  //////////////////////////////////////

//    (aud_bclk)                // Horloge pour les données
//                              // du CODEC
//    (aud_adcdat)              // Données de l'ADC
//    (aud_adclrck)             // indicateur Gauche/Droite
//                              // pour les données de l'ADC
//    (aud_dacdat)              // Données de le DAC
//    (aud_daclrck)             // indicateur Gauche/Droite
//                              // pour les données de l'ADC

assign aud_adclrck  =  1'bz;
assign aud_daclrck  =  1'bz;
assign aud_bclk     =  1'bz;

// On relie ici la sortie de l'ADC à l'entrée du DAC /////////////////
// Signal série sur 1bit                             /////////////////
wire   donnees_audio;
assign donnees_audio = aud_adcdat;
assign aud_dacdat = sw[9]? donnees_audio : 1'b0;

sound sound_i (
    .clk      ( clock_50      ) ,  // Horloge système à 50MHz
    .nrst     ( key[0]        ) ,  // RESET
    .i2c_sclk ( fpga_i2c_sclk ) ,  // Horloge I2C
    .i2c_sdat ( fpga_i2c_sdat ) ,  // Données I2C
    .aud_xck  ( aud_xck       )    // Horloge du CODEC
);

//////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
//         Video VGA     ////////////////////////////////////////////

wire [10:0] x;
wire [9:0] y;
wire [7:0] ri;
wire [7:0] gi;
wire [7:0] bi;
wire eof;
wire vga_nrst;

//////////////////////////////////////////////////////////////////////
/////  Le controle des signaux  VGA///////////////////////////////////
//////////////////////////////////////////////////////////////////////
vga vga_i (
   .clk         ( clock_50    ) ,
   .aRST        ( ~key[0]     ) , // reset asynchrone pour la pll vga
   .vga_nrst    ( vga_nrst    ) , // reset tant que la pll n'est pas locked
   .x           ( x           ) ,
   .y           ( y           ) ,
   .r           ( ri          ) ,
   .g           ( gi          ) ,
   .b           ( bi          ) ,
   .eof         ( eof         ) ,
   .vga_hs      ( vga_hs      ) ,
   .vga_vs      ( vga_vs      ) ,
   .vga_clk     ( vga_clk     ) ,
   .vga_blank_n ( vga_blank_n ) ,
   .vga_sync_n  ( vga_sync_n  ) ,
   .vga_r       ( vga_r       ) ,
   .vga_g       ( vga_g       ) ,
   .vga_b       ( vga_b       )
);

//////////////////////////////////////////////////////////////////////
//////    Générer les pixels  et controler la souris   ///////////////
//////////////////////////////////////////////////////////////////////
logic clk_div;
logic forward;
logic rotate_r;
logic rotate_l;
logic hit_left;
logic hit_right;

draw_unit draw (
   .clk       ( vga_clk  ) ,
   .nrst      ( vga_nrst ) ,
   // Vers le VGA
   .vga_x     ( x        ) ,
   .vga_y     ( y        ) ,
   .r         ( ri       ) ,
   .g         ( gi       ) ,
   .b         ( bi       ) ,
   .eof       ( eof      ) ,
   // reset synchrone de la souris
   // et changement de carte
   .next_maze ( k3_event  ),
   // vers la souris
   .clk_div   ( clk_div   ) ,
	.turbo     ( sw[1]     ) ,
   .forward   ( forward   ) ,
   .rotate_l  ( rotate_r  ) ,
   .rotate_r  ( rotate_l  ) ,
   .hit_left  ( hit_left  ) ,
   .hit_right ( hit_right )
);

//TODO assign ledg[0] = hit_right;
//TODO assign ledg[7] = hit_left;

//////////////////////////////////////////////////////////////////////
//////    La souris  !!! /////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//
// detecteur de fronts sur key[3] pour changer les labyrinthes
logic [1:0] r_key3;
logic k3_event ;
always  @(posedge vga_clk)
  begin
    r_key3   <= {r_key3[0],key[3]};
    k3_event <=  r_key3[1] & !r_key3[0];
  end


mouse mickey(
   .clk       ( clk_div               ) ,
   .nreset    ( vga_nrst && !k3_event ) ,
   .go        ( sw[0]                 ) ,
   .forward   ( forward               ) ,
   .rotate_r  ( rotate_r              ) ,
   .rotate_l  ( rotate_l              ) ,
   .hit_left  ( hit_left              ) ,
   .hit_right ( hit_right             )
);


//////////////////////////////////////////////////////////////////////
//    Tous les ports en entrees/sorties mis au 3e etat       /////////
//////////////////////////////////////////////////////////////////////
assign gpio_0        = 'z;
assign gpio_1        = 'z;
assign fpga_i2c_sdat = 'z;

endmodule
