#**************************************************************
# This .sdc file is created by Terasic Tool.
# Users are recommended to modify this file to match users logic.
#**************************************************************

#**************************************************************
# Create Clock
#**************************************************************
create_clock -period 20 -name CLOCK_50MHz [get_ports clock_50]

# analog video decoder clock
create_clock -period "18.432 MHz" -name clk_audxck [get_ports aud_xck]
create_clock -period "1.536 MHz"  -name clk_audbck [get_ports aud_bclk]

#**************************************************************
# Create Generated Clock
#**************************************************************
derive_pll_clocks

# The vga clock comes from the vga_pll
# http://www.altera.com/support/examples/timequest/exm-tq-basic-source-sync.html
create_generated_clock -name clk_vga \
  -source [get_pins -compatibility_mode *vga_pll*divclk] [get_ports vga_clk]

# VGA (depending on the image size)
# VGA : 640x480@60Hz
#create_clock -period "25.18 MHz" -name clk_vga [get_ports vga_clk]
# VGA : 800x600@60Hz
#create_clock -period "40.0 MHz" -name clk_vga [get_ports vga_clk]
# VGA : 1024x768@60Hz
#create_clock -period "65.0 MHz" -name clk_vga [get_ports vga_clk]
# VGA : 1280x1024@60Hz
#create_clock -period "108.0 MHz" -name clk_vga [get_ports vga_clk]


#**************************************************************
# Set Clock Latency
#**************************************************************

#**************************************************************
# Set Clock Uncertainty
#**************************************************************
derive_clock_uncertainty

#**************************************************************
# Set Input Delay
#**************************************************************

#**************************************************************
# Set Output Delay
#**************************************************************
# max : Board Delay (Data) - Board Delay (Clock) + tsu (External Device)
# min : Board Delay (Data) - Board Delay (Clock) - th (External Device)
set_output_delay -max -clock clk_vga 0.220   [ get_ports vga_r\[*\]  ]
set_output_delay -min -clock clk_vga -1.506  [ get_ports vga_r\[*\]  ]
set_output_delay -max -clock clk_vga 0.212   [ get_ports vga_g\[*\]  ]
set_output_delay -min -clock clk_vga -1.519  [ get_ports vga_g\[*\]  ]
set_output_delay -max -clock clk_vga 0.264   [ get_ports vga_b\[*\]  ]
set_output_delay -min -clock clk_vga -1.519  [ get_ports vga_b\[*\]  ]
set_output_delay -max -clock clk_vga 0.215   [ get_ports vga_blank_n ]
set_output_delay -min -clock clk_vga -1.485  [ get_ports vga_blank_n ]

#**************************************************************
# Set Clock Groups
#**************************************************************

#**************************************************************
# Set False Path
#**************************************************************

#**************************************************************
# Set Multicycle Path
#**************************************************************

#**************************************************************
# Set Maximum Delay
#**************************************************************

#**************************************************************
# Set Minimum Delay
#**************************************************************

#**************************************************************
# Set Input Transition
#**************************************************************

#**************************************************************
# Set Load
#**************************************************************

