-------------------------------------------------------------------------------
--                                                                           --
--                                                                           --
-- Auteurs         : JLD                                                     --
-- Projet          : PROJET-EXEMPLE                                          --
--                                                                           --
--                                                                           --
-- Description     : exemple de projet : TOP                                 --
--                                                                           --
--  Copyright Télécom ParisTECH 2012                                         --
--                                                                           --
-------------------------------------------------------------------------------
-- Modification :                                                            --
-------------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity TOP is
  port
    (
      CLK    : in  std_logic;
      NRST   : in  std_logic;
      WR     : in  std_logic;
      RD     : in  std_logic;
      FULL   : out std_logic;
      EMPTY  : buffer  std_logic;
      A      : in  std_logic_vector(15 downto 8);
      B      : in  std_logic_vector(7 downto 0);
      Q      : out signed(15 downto 0);
      probes : out std_logic_vector(15 downto 0)
      );
end TOP;

architecture RTL of TOP is

  constant fifo_depth   : positive := 10;
  constant bits_donnee  : positive := 16;
  constant fifo_latence : positive := 1;
  constant mult_latence : positive := 2;

  signal fifo_in  : std_logic_vector(15 downto 0);
  signal fifo_out : std_logic_vector(15 downto 0);
  signal mult_out : signed(15 downto 0);
  signal rd_fifo : std_logic;
  
begin


-- sondes
  probes <= fifo_out;
--

  
  fifo_in <= A & B;
  rd_fifo <= RD and not(EMPTY);
  
  INST_FIFO : entity WORK.fifo(bev)
    generic map
    (
      WIDTH => bits_donnee,
      DEPTH => fifo_depth
      )
    port map
    (
      clock => CLK,
      rst_n => NRST,
      wrreq => WR,
      full  => FULL,
      data  => fifo_in,
      rdreq => RD,
      empty => EMPTY,
      q     => fifo_out
      );                                                

  INST_MULT : entity WORK.mult(bev)
    generic map
    (
      bits_donnee   => bits_donnee/2,
      mult_pipeline => mult_latence
      )
    port map
    (
      CLK   => CLK,
      N_RST => NRST,
      A     => signed(fifo_out(15 downto 8)),
      B     => signed(fifo_out(7 downto 0)),
      S     => mult_out
      );


  INST_ACCU : entity WORK.ACCU(RTL)
    generic map
    (
      bits_donnee => bits_donnee,
      latence     => fifo_latence + mult_latence 
      )
    port map (
      CLK  => CLK,
      NRST => NRST,
      EN   => rd_fifo,
      D    => mult_out,
      Q    => Q
      );
end RTL;
