/*******************************************************************************
 * Tlcom ParisTECH 2012
 * Module de rfrence pour la carte DE2 
 ******************************************************************************/


module DE2_TOP
   (
      ////////////////////   Clock Input       ////////////////////    
      CLOCK_27,                //   27 MHz
      CLOCK_50,                //   50 MHz
      EXT_CLOCK,               //   External Clock
      ////////////////////   Push Button      ////////////////////
      KEY,                     //   Pushbutton[3:0]
      ////////////////////   DPDT Switch      ////////////////////
      SW,                        //   Toggle Switch[17:0]
      ////////////////////   7-SEG Dispaly   ////////////////////
      HEX0,                    //   Seven Segment Digit 0
      HEX1,                    //   Seven Segment Digit 1
      HEX2,                    //   Seven Segment Digit 2
      HEX3,                    //   Seven Segment Digit 3
      HEX4,                    //   Seven Segment Digit 4
      HEX5,                    //   Seven Segment Digit 5
      HEX6,                    //   Seven Segment Digit 6
      HEX7,                    //   Seven Segment Digit 7
      ////////////////////////   LED      ////////////////////////
      LEDG,                    //   LED Green[8:0]
      LEDR,                    //   LED Red[17:0]
      ////////////////////////   UART   ////////////////////////
      UART_TXD,                //   UART Transmitter
      UART_RXD,                //   UART Receiver
      ////////////////////////   IRDA   ////////////////////////
      IRDA_TXD,                //   IRDA Transmitter
      IRDA_RXD,                //   IRDA Receiver
      /////////////////////   SDRAM Interface      ////////////////
      DRAM_DQ,                 //   SDRAM Data bus 16 Bits
      DRAM_ADDR,               //   SDRAM Address bus 12 Bits
      DRAM_LDQM,               //   SDRAM Low-byte Data Mask 
      DRAM_UDQM,               //   SDRAM High-byte Data Mask
      DRAM_WE_N,               //   SDRAM Write Enable
      DRAM_CAS_N,              //   SDRAM Column Address Strobe
      DRAM_RAS_N,              //   SDRAM Row Address Strobe
      DRAM_CS_N,               //   SDRAM Chip Select
      DRAM_BA_0,               //   SDRAM Bank Address 0
      DRAM_BA_1,               //   SDRAM Bank Address 0
      DRAM_CLK,                //   SDRAM Clock
      DRAM_CKE,                //   SDRAM Clock Enable
      ////////////////////   Flash Interface      ////////////////
      FL_DQ,                   //   FLASH Data bus 8 Bits
      FL_ADDR,                 //   FLASH Address bus 22 Bits
      FL_WE_N,                 //   FLASH Write Enable
      FL_RST_N,                //   FLASH Reset
      FL_OE_N,                 //   FLASH Output Enable
      FL_CE_N,                 //   FLASH Chip Enable
      ////////////////////   SRAM Interface      ////////////////
      SRAM_DQ,                 //   SRAM Data bus 16 Bits
      SRAM_ADDR,               //   SRAM Address bus 18 Bits
      SRAM_UB_N,               //   SRAM High-byte Data Mask 
      SRAM_LB_N,               //   SRAM Low-byte Data Mask 
      SRAM_WE_N,               //   SRAM Write Enable
      SRAM_CE_N,               //   SRAM Chip Enable
      SRAM_OE_N,               //   SRAM Output Enable
      ////////////////////   ISP1362 Interface   ////////////////
      OTG_DATA,                //   ISP1362 Data bus 16 Bits
      OTG_ADDR,                //   ISP1362 Address 2 Bits
      OTG_CS_N,                //   ISP1362 Chip Select
      OTG_RD_N,                //   ISP1362 Write
      OTG_WR_N,                //   ISP1362 Read
      OTG_RST_N,               //   ISP1362 Reset
      OTG_FSPEED,              //   USB Full Speed,   0 = Enable, Z = Disable
      OTG_LSPEED,              //   USB Low Speed,    0 = Enable, Z = Disable
      OTG_INT0,                //   ISP1362 Interrupt 0
      OTG_INT1,                //   ISP1362 Interrupt 1
      OTG_DREQ0,               //   ISP1362 DMA Request 0
      OTG_DREQ1,               //   ISP1362 DMA Request 1
      OTG_DACK0_N,             //   ISP1362 DMA Acknowledge 0
      OTG_DACK1_N,             //   ISP1362 DMA Acknowledge 1
      ////////////////////   LCD Module 16X2      ////////////////
      LCD_ON,                  //   LCD Power ON/OFF
      LCD_BLON,                //   LCD Back Light ON/OFF
      LCD_RW,                  //   LCD Read/Write Select, 0 = Write, 1 = Read
      LCD_EN,                  //   LCD Enable
      LCD_RS,                  //   LCD Command/Data Select, 0 = Command, 1 = Data
      LCD_DATA,                //   LCD Data bus 8 bits
      ////////////////////   SD_Card Interface   ////////////////
      SD_DAT,                  //   SD Card Data
      SD_DAT3,                 //   SD Card Data 3
      SD_CMD,                  //   SD Card Command Signal
      SD_CLK,                  //   SD Card Clock
      ////////////////////   USB JTAG link   ////////////////////
      TDI,                     // CPLD -> FPGA (data in)
      TCK,                     // CPLD -> FPGA (clk)
      TCS,                     // CPLD -> FPGA (CS)
       TDO,                    // FPGA -> CPLD (data out)
      ////////////////////   I2C      ////////////////////////////
      I2C_SDAT,                //   I2C Data
      I2C_SCLK,                //   I2C Clock
      ////////////////////   PS2      ////////////////////////////
      PS2_DAT,                 //   PS2 Data
      PS2_CLK,                 //   PS2 Clock
      ////////////////////   VGA      ////////////////////////////
      VGA_CLK,                 //   VGA Clock
      VGA_HS,                  //   VGA H_SYNC
      VGA_VS,                  //   VGA V_SYNC
      VGA_BLANK,               //   VGA BLANK
      VGA_SYNC,                //   VGA SYNC
      VGA_R,                   //   VGA Red[9:0]
      VGA_G,                   //   VGA Green[9:0]
      VGA_B,                   //   VGA Blue[9:0]
      ////////////   Ethernet Interface   ////////////////////////
      ENET_DATA,               //   DM9000A DATA bus 16Bits
      ENET_CMD,                //   DM9000A Command/Data Select, 0 = Command, 1 = Data
      ENET_CS_N,               //   DM9000A Chip Select
      ENET_WR_N,               //   DM9000A Write
      ENET_RD_N,               //   DM9000A Read
      ENET_RST_N,              //   DM9000A Reset
      ENET_INT,                //   DM9000A Interrupt
      ENET_CLK,                //   DM9000A Clock 25 MHz
      ////////////////   Audio CODEC      ////////////////////////
      AUD_ADCLRCK,             //   Audio CODEC ADC LR Clock
      AUD_ADCDAT,              //   Audio CODEC ADC Data
      AUD_DACLRCK,             //   Audio CODEC DAC LR Clock
      AUD_DACDAT,              //   Audio CODEC DAC Data
      AUD_BCLK,                //   Audio CODEC Bit-Stream Clock
      AUD_XCK,                 //   Audio CODEC Chip Clock
      ////////////////   TV Decoder      ////////////////////////
      TD_DATA,                 //   TV Decoder Data bus 8 bits
      TD_HS,                   //   TV Decoder H_SYNC
      TD_VS,                   //   TV Decoder V_SYNC
      TD_RESET,                //   TV Decoder Reset
      TD_CLK,                  //   TV Decoder Clock
      ////////////////////   GPIO   ////////////////////////////
      GPIO_0,                  //   GPIO Connection 0
      GPIO_1                   //   GPIO Connection 1
   );

////////////////////////   Clock Input       ////////////////////////
input          CLOCK_27;       //   27 MHz
input          CLOCK_50;       //   50 MHz
input          EXT_CLOCK;      //   External Clock
////////////////////////   Push Button      ////////////////////////
input   [3:0]   KEY;           //   Pushbutton[3:0]
////////////////////////   DPDT Switch      ////////////////////////
input   [17:0]   SW;           //   Toggle Switch[17:0]
////////////////////////   7-SEG Dispaly   ////////////////////////
output   [6:0]   HEX0;         //   Seven Segment Digit 0
output   [6:0]   HEX1;         //   Seven Segment Digit 1
output   [6:0]   HEX2;         //   Seven Segment Digit 2
output   [6:0]   HEX3;         //   Seven Segment Digit 3
output   [6:0]   HEX4;         //   Seven Segment Digit 4
output   [6:0]   HEX5;         //   Seven Segment Digit 5
output   [6:0]   HEX6;         //   Seven Segment Digit 6
output   [6:0]   HEX7;         //   Seven Segment Digit 7
////////////////////////////   LED      ////////////////////////////
output   [8:0]   LEDG;         //   LED Green[8:0]
output   [17:0]   LEDR;        //   LED Red[17:0]
////////////////////////////   UART   ////////////////////////////
output         UART_TXD;       //   UART Transmitter
input          UART_RXD;       //   UART Receiver
////////////////////////////   IRDA   ////////////////////////////
output         IRDA_TXD;       //   IRDA Transmitter
input          IRDA_RXD;       //   IRDA Receiver
///////////////////////      SDRAM Interface   ////////////////////////
inout   [15:0]   DRAM_DQ;      //   SDRAM Data bus 16 Bits
output   [11:0]   DRAM_ADDR;   //   SDRAM Address bus 12 Bits
output         DRAM_LDQM;      //   SDRAM Low-byte Data Mask 
output         DRAM_UDQM;      //   SDRAM High-byte Data Mask
output         DRAM_WE_N;      //   SDRAM Write Enable
output         DRAM_CAS_N;     //   SDRAM Column Address Strobe
output         DRAM_RAS_N;     //   SDRAM Row Address Strobe
output         DRAM_CS_N;      //   SDRAM Chip Select
output         DRAM_BA_0;      //   SDRAM Bank Address 0
output         DRAM_BA_1;      //   SDRAM Bank Address 0
output         DRAM_CLK;       //   SDRAM Clock
output         DRAM_CKE;       //   SDRAM Clock Enable
////////////////////////   Flash Interface   ////////////////////////
inout   [7:0]   FL_DQ;         //   FLASH Data bus 8 Bits
output   [21:0]   FL_ADDR;     //   FLASH Address bus 22 Bits
output         FL_WE_N;        //   FLASH Write Enable
output         FL_RST_N;       //   FLASH Reset
output         FL_OE_N;        //   FLASH Output Enable
output         FL_CE_N;        //   FLASH Chip Enable
////////////////////////   SRAM Interface   ////////////////////////
inout   [15:0]   SRAM_DQ;      //   SRAM Data bus 16 Bits
output   [17:0]   SRAM_ADDR;   //   SRAM Address bus 18 Bits
output         SRAM_UB_N;      //   SRAM High-byte Data Mask 
output         SRAM_LB_N;      //   SRAM Low-byte Data Mask 
output         SRAM_WE_N;      //   SRAM Write Enable
output         SRAM_CE_N;      //   SRAM Chip Enable
output         SRAM_OE_N;      //   SRAM Output Enable
////////////////////   ISP1362 Interface   ////////////////////////
inout   [15:0]   OTG_DATA;     //   ISP1362 Data bus 16 Bits
output   [1:0]   OTG_ADDR;     //   ISP1362 Address 2 Bits
output         OTG_CS_N;       //   ISP1362 Chip Select
output         OTG_RD_N;       //   ISP1362 Write
output         OTG_WR_N;       //   ISP1362 Read
output         OTG_RST_N;      //   ISP1362 Reset
output         OTG_FSPEED;     //   USB Full Speed,   0 = Enable, Z = Disable
output         OTG_LSPEED;     //   USB Low Speed,    0 = Enable, Z = Disable
input          OTG_INT0;       //   ISP1362 Interrupt 0
input          OTG_INT1;       //   ISP1362 Interrupt 1
input          OTG_DREQ0;      //   ISP1362 DMA Request 0
input          OTG_DREQ1;      //   ISP1362 DMA Request 1
output         OTG_DACK0_N;    //   ISP1362 DMA Acknowledge 0
output         OTG_DACK1_N;    //   ISP1362 DMA Acknowledge 1
////////////////////   LCD Module 16X2   ////////////////////////////
inout   [7:0]   LCD_DATA;      //   LCD Data bus 8 bits
output         LCD_ON;         //   LCD Power ON/OFF
output         LCD_BLON;       //   LCD Back Light ON/OFF
output         LCD_RW;         //   LCD Read/Write Select, 0 = Write, 1 = Read
output         LCD_EN;         //   LCD Enable
output         LCD_RS;         //   LCD Command/Data Select, 0 = Command, 1 = Data
////////////////////   SD Card Interface   ////////////////////////
inout          SD_DAT;         //   SD Card Data
inout          SD_DAT3;        //   SD Card Data 3
inout          SD_CMD;         //   SD Card Command Signal
output         SD_CLK;         //   SD Card Clock
////////////////////////   I2C      ////////////////////////////////
inout          I2C_SDAT;       //   I2C Data
output         I2C_SCLK;       //   I2C Clock
////////////////////////   PS2      ////////////////////////////////
input           PS2_DAT;       //   PS2 Data
input          PS2_CLK;        //   PS2 Clock
////////////////////   USB JTAG link   ////////////////////////////
input           TDI;           // CPLD -> FPGA (data in)
input           TCK;           // CPLD -> FPGA (clk)
input           TCS;           // CPLD -> FPGA (CS)
output          TDO;           // FPGA -> CPLD (data out)
////////////////////////   VGA         ////////////////////////////
output         VGA_CLK;        //   VGA Clock
output         VGA_HS;         //   VGA H_SYNC
output         VGA_VS;         //   VGA V_SYNC
output         VGA_BLANK;      //   VGA BLANK
output         VGA_SYNC;       //   VGA SYNC
output   [9:0]   VGA_R;        //   VGA Red[9:0]
output   [9:0]   VGA_G;        //   VGA Green[9:0]
output   [9:0]   VGA_B;        //   VGA Blue[9:0]
////////////////   Ethernet Interface   ////////////////////////////
inout   [15:0]   ENET_DATA;    //   DM9000A DATA bus 16Bits
output         ENET_CMD;       //   DM9000A Command/Data Select, 0 = Command, 1 = Data
output         ENET_CS_N;      //   DM9000A Chip Select
output         ENET_WR_N;      //   DM9000A Write
output         ENET_RD_N;      //   DM9000A Read
output         ENET_RST_N;     //   DM9000A Reset
input          ENET_INT;       //   DM9000A Interrupt
output         ENET_CLK;       //   DM9000A Clock 25 MHz
////////////////////   Audio CODEC      ////////////////////////////
inout          AUD_ADCLRCK;    //   Audio CODEC ADC LR Clock
input          AUD_ADCDAT;     //   Audio CODEC ADC Data
inout          AUD_DACLRCK;    //   Audio CODEC DAC LR Clock
output         AUD_DACDAT;     //   Audio CODEC DAC Data
inout          AUD_BCLK;       //   Audio CODEC Bit-Stream Clock
output         AUD_XCK;        //   Audio CODEC Chip Clock
////////////////////   TV Devoder      ////////////////////////////
input   [7:0]   TD_DATA;       //   TV Decoder Data bus 8 bits
input          TD_HS;          //   TV Decoder H_SYNC
input          TD_VS;          //   TV Decoder V_SYNC
output         TD_RESET;       //   TV Decoder Reset
input          TD_CLK;         //   TV Decoder Clock
////////////////////////   GPIO   ////////////////////////////////
inout   [35:0]   GPIO_0;       //   GPIO Connection 0
inout   [35:0]   GPIO_1;       //   GPIO Connection 1

  //   Turn on all display
  // assign   HEX0      =   7'h00;
  // assign   HEX1      =   7'h00;
  // assign   HEX2      =   7'h00;
  // assign   HEX3      =   7'h00;
  // assign   HEX4      =   7'h00;
  // assign   HEX5      =   7'hFF;
  // assign   HEX6      =   7'hFF;
  // assign   HEX7      =   7'hFF;
  assign   LEDG       = 9'h000;
  assign   LEDR[17:2] = 18'h00000;
  
  
  //  top instance
  wire [7:0] A,B;
  assign A = SW[17:10];
  assign B = SW[9:2];
  
  wire [15:0] Q, PROBES;
  wire FULL,EMPTY;
  
  top inst_top (
                .A      ( A       ) ,
                .B      ( B       ) ,
                .WR     ( SW[1]   ) ,
                .CLK    ( ~KEY[3] ) ,
                .NRST   ( KEY[0]  ) ,
                .Q      ( Q       ) ,
                .RD     ( SW[0]   ) ,
                .FULL   ( FULL    ) ,
                .EMPTY  ( EMPTY   ) ,
                .probes ( PROBES  )
             );
  
  // afficheurs 7seg pour rsultat
  seg_dec AFF_HEX0(.num_in(Q[3  : 0])       , .seg_out(HEX0));
  seg_dec AFF_HEX1(.num_in(Q[7  : 4])       , .seg_out(HEX1));
  seg_dec AFF_HEX2(.num_in(Q[11 : 8])       , .seg_out(HEX2));
  seg_dec AFF_HEX3(.num_in(Q[15 : 12])      , .seg_out(HEX3));

  seg_dec AFF_HEX4(.num_in(PROBES[3  : 0])  , .seg_out(HEX4));
  seg_dec AFF_HEX5(.num_in(PROBES[7  : 4])  , .seg_out(HEX5));
  seg_dec AFF_HEX6(.num_in(PROBES[11 : 8])  , .seg_out(HEX6));
  seg_dec AFF_HEX7(.num_in(PROBES[15 : 12]) , .seg_out(HEX7));

  //FE_dec pour afficher E/F
  assign LEDR[0]= FULL;
  assign LEDR[1]= EMPTY;
  //FE_dec AFF_HEX4(.full(FULL),.empty(EMPTY),.seg_out(HEX4)); 
  
  //   All inout port turn to tri-state
  assign   DRAM_DQ           = 16'hzzzz;
  assign   FL_DQ             = 8'hzz;
  assign   SRAM_DQ           = 16'hzzzz;
  assign   OTG_DATA          = 16'hzzzz;
  assign   LCD_DATA          = 8'hzz;
  assign   SD_DAT            = 1'bz;
  assign   I2C_SDAT          = 1'bz;
  assign   ENET_DATA         = 16'hzzzz;
  assign   AUD_ADCLRCK       = 1'bz;
  assign   AUD_DACLRCK       = 1'bz;
  assign   AUD_BCLK          = 1'bz;
  assign   GPIO_0            = 36'hzzzzzzzzz;
  assign   GPIO_1            = 36'hzzzzzzzzz;

  // LCD off
  assign  LCD_DATA           = 8'hzz;
  assign  LCD_ON             = 1'b0;
  assign  LCD_BLON           = 1'b0;
  assign  LCD_RW             = 1'b0;
  assign  LCD_EN             = 1'b0;
  assign  LCD_RS             = 1'b0;
  
endmodule

/******************************************************************************/
/* Cette partie contient des modules utilitaires pour le contrle des
 * afficheurs sept segments 
 ******************************************************************************/

// Dcodeur 7 segments
// Entre num_in sur 4 bits
// Sortie seg_out sur 7 bits

module seg_dec(
               input  [3:0]num_in,
               output reg [6:0]seg_out
               );

always @(num_in)
begin
   case (num_in)
     //                 bit: 6543210
      4'h0:    seg_out <= 7'b1000000;
      4'h1:    seg_out <= 7'b1111001;
      4'h2:    seg_out <= 7'b0100100;
      4'h3:    seg_out <= 7'b0110000;
      4'h4:    seg_out <= 7'b0011001;
      4'h5:    seg_out <= 7'b0010010;
      4'h6:    seg_out <= 7'b0000010;
      4'h7:    seg_out <= 7'b1111000;
      4'h8:    seg_out <= 7'b0000000;
      4'h9:    seg_out <= 7'b0010000;
      4'hA:    seg_out <= 7'b0001000;
      4'hB:    seg_out <= 7'b0000011;
      4'hC:    seg_out <= 7'b1000110;
      4'hD:    seg_out <= 7'b0100001;
      4'hE:    seg_out <= 7'b0000110;
      4'hF:    seg_out <= 7'b0001110;
      default: seg_out <= 7'b1111111;
   endcase
end


endmodule



// Dcodeur 7 segments
// Entre binaire bit_in sur 1 bits
// Sortie seg_out sur 7 bits

module bin_seg_dec(
                    input bit_in,
                    output reg [6:0]seg_out
                    );

always @(bit_in)
begin
   case (bit_in)
     //                 bit: 6543210
      0:       seg_out <= 7'b1000000;
      1:       seg_out <= 7'b1111001;
      default: seg_out <= 7'b1111111;
   endcase
end
endmodule

// Dcodeur 7 segments Empty/Full
// pour la fifo
// Sortie seg_out sur 7 bits

module FE_dec(
               input  full,
               input  empty,
               output reg [6:0] seg_out
             );

always @(*)
begin
   case ({full,empty})
     //                 bit: 6543210
      2'b01:   seg_out <= 7'b0000110;
      2'b10:   seg_out <= 7'b0001110;
      default: seg_out <= 7'b1000000;
   endcase
end


endmodule

