// ============================================================================
// Copyright (c) 2013 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development 
//   Kits made by Terasic.  Other use of this code, including the selling 
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use 
//   or functionality of this code.
//
// ============================================================================
//           
//  Terasic Technologies Inc
//  9F., No.176, Sec.2, Gongdao 5th Rd, East Dist, Hsinchu City, 30070. Taiwan
//  
//  
//                     web: http://www.terasic.com/  
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Thu Jul 11 11:26:45 2013
// ============================================================================

//`define ENABLE_HPS


module DE1_SoC(

      ///////// ADC /////////
      output             ADC_CONVST,
      output             ADC_DIN,
      input              ADC_DOUT,
      output             ADC_SCLK,

      ///////// AUD /////////
      input              AUD_ADCDAT,
      inout              AUD_ADCLRCK,
      inout              AUD_BCLK,
      output             AUD_DACDAT,
      inout              AUD_DACLRCK,
      output             AUD_XCK,

      ///////// CLOCK2 /////////
      input              CLOCK2_50,

      ///////// CLOCK3 /////////
      input              CLOCK3_50,

      ///////// CLOCK4 /////////
      input              CLOCK4_50,

      ///////// CLOCK /////////
      input              CLOCK_50,

      ///////// DRAM /////////
      output      [12:0] DRAM_ADDR,
      output      [1:0]  DRAM_BA,
      output             DRAM_CAS_N,
      output             DRAM_CKE,
      output             DRAM_CLK,
      output             DRAM_CS_N,
      inout       [15:0] DRAM_DQ,
      output             DRAM_LDQM,
      output             DRAM_RAS_N,
      output             DRAM_UDQM,
      output             DRAM_WE_N,

      ///////// FAN /////////
      output             FAN_CTRL,

      ///////// FPGA /////////
      output             FPGA_I2C_SCLK,
      inout              FPGA_I2C_SDAT,

      ///////// GPIO /////////
      inout     [35:0]         GPIO_0,
      inout     [35:0]         GPIO_1,
 

      ///////// HEX0 /////////
      output      [6:0]  HEX0,

      ///////// HEX1 /////////
      output      [6:0]  HEX1,

      ///////// HEX2 /////////
      output      [6:0]  HEX2,

      ///////// HEX3 /////////
      output      [6:0]  HEX3,

      ///////// HEX4 /////////
      output      [6:0]  HEX4,

      ///////// HEX5 /////////
      output      [6:0]  HEX5,

`ifdef ENABLE_HPS
      ///////// HPS /////////
      inout              HPS_CONV_USB_N,
      output      [14:0] HPS_DDR3_ADDR,
      output      [2:0]  HPS_DDR3_BA,
      output             HPS_DDR3_CAS_N,
      output             HPS_DDR3_CKE,
      output             HPS_DDR3_CK_N,
      output             HPS_DDR3_CK_P,
      output             HPS_DDR3_CS_N,
      output      [3:0]  HPS_DDR3_DM,
      inout       [31:0] HPS_DDR3_DQ,
      inout       [3:0]  HPS_DDR3_DQS_N,
      inout       [3:0]  HPS_DDR3_DQS_P,
      output             HPS_DDR3_ODT,
      output             HPS_DDR3_RAS_N,
      output             HPS_DDR3_RESET_N,
      input              HPS_DDR3_RZQ,
      output             HPS_DDR3_WE_N,
      output             HPS_ENET_GTX_CLK,
      inout              HPS_ENET_INT_N,
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input       [3:0]  HPS_ENET_RX_DATA,
      input              HPS_ENET_RX_DV,
      output      [3:0]  HPS_ENET_TX_DATA,
      output             HPS_ENET_TX_EN,
      inout       [3:0]  HPS_FLASH_DATA,
      output             HPS_FLASH_DCLK,
      output             HPS_FLASH_NCSO,
      inout              HPS_GSENSOR_INT,
      inout              HPS_I2C1_SCLK,
      inout              HPS_I2C1_SDAT,
      inout              HPS_I2C2_SCLK,
      inout              HPS_I2C2_SDAT,
      inout              HPS_I2C_CONTROL,
      inout              HPS_KEY,
      inout              HPS_LED,
      inout              HPS_LTC_GPIO,
      output             HPS_SD_CLK,
      inout              HPS_SD_CMD,
      inout       [3:0]  HPS_SD_DATA,
      output             HPS_SPIM_CLK,
      input              HPS_SPIM_MISO,
      output             HPS_SPIM_MOSI,
      inout              HPS_SPIM_SS,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLKOUT,
      inout       [7:0]  HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// IRDA /////////
      input              IRDA_RXD,
      output             IRDA_TXD,

      ///////// KEY /////////
      input       [3:0]  KEY,

      ///////// LEDR /////////
      output      [9:0]  LEDR,

      ///////// PS2 /////////
      inout              PS2_CLK,
      inout              PS2_CLK2,
      inout              PS2_DAT,
      inout              PS2_DAT2,

      ///////// SW /////////
      input       [9:0]  SW,

      ///////// TD /////////
      input              TD_CLK27,
      input      [7:0]  TD_DATA,
      input             TD_HS,
      output             TD_RESET_N,
      input             TD_VS,

      ///////// VGA /////////
      output      [7:0]  VGA_B,
      output             VGA_BLANK_N,
      output             VGA_CLK,
      output      [7:0]  VGA_G,
      output             VGA_HS,
      output      [7:0]  VGA_R,
      output             VGA_SYNC_N,
      output             VGA_VS
);


//=======================================================
//  REG/WIRE declarations
//=======================================================

  wire [7:0] A,B;
  assign A = SW[9:6];
  assign B = SW[5:2];
  
  wire [15:0] Q, PROBES;
  wire FULL,EMPTY;




//=======================================================
//  Structural coding
//=======================================================

  top inst_top (
                .A      ( A       ) ,
                .B      ( B       ) ,
                .WR     ( SW[1]   ) ,
                .CLK    ( ~KEY[3] ) ,
                .NRST   ( KEY[0]  ) ,
                .Q      ( Q       ) ,
                .RD     ( SW[0]   ) ,
                .FULL   ( FULL    ) ,
                .EMPTY  ( EMPTY   ) ,
                .probes ( PROBES  )
             );
  // afficheurs 7seg pour résultat
  seg_dec AFF_HEX0(.num_in(Q[3  : 0])       , .seg_out(HEX0));
  seg_dec AFF_HEX1(.num_in(Q[7  : 4])       , .seg_out(HEX1));
  seg_dec AFF_HEX2(.num_in(Q[11 : 8])       , .seg_out(HEX2));
  seg_dec AFF_HEX3(.num_in(Q[15 : 12])      , .seg_out(HEX3));

  seg_dec AFF_HEX4(.num_in(PROBES[3  : 0])  , .seg_out(HEX4));
  seg_dec AFF_HEX5(.num_in(PROBES[7  : 4])  , .seg_out(HEX5));
  //seg_dec AFF_HEX6(.num_in(PROBES[11 : 8])  , .seg_out(HEX6));
  //seg_dec AFF_HEX7(.num_in(PROBES[15 : 12]) , .seg_out(HEX7));


  //FE_dec pour afficher E/F
  assign LEDR[0]= FULL;
  assign LEDR[1]= EMPTY;
  //FE_dec AFF_HEX4(.full(FULL),.empty(EMPTY),.seg_out(HEX4)); 
  
  //   All inout port turn to tri-state
  assign   DRAM_DQ           = 16'hzzzz;
  assign   AUD_ADCLRCK       = 1'bz;
  assign   AUD_DACLRCK       = 1'bz;
  assign   AUD_BCLK          = 1'bz;
  assign   GPIO_0            = 36'hzzzzzzzzz;
  assign   GPIO_1            = 36'hzzzzzzzzz;



endmodule
/******************************************************************************/
/* Cette partie contient des modules utilitaires pour le contrôle des
 * afficheurs sept segments 
 ******************************************************************************/

// Décodeur 7 segments
// Entrée num_in sur 4 bits
// Sortie seg_out sur 7 bits

module seg_dec(
               input  [3:0]num_in,
               output reg [6:0]seg_out
               );

always @(num_in)
begin
   case (num_in)
     //                 bit: 6543210
      4'h0:    seg_out <= 7'b1000000;
      4'h1:    seg_out <= 7'b1111001;
      4'h2:    seg_out <= 7'b0100100;
      4'h3:    seg_out <= 7'b0110000;
      4'h4:    seg_out <= 7'b0011001;
      4'h5:    seg_out <= 7'b0010010;
      4'h6:    seg_out <= 7'b0000010;
      4'h7:    seg_out <= 7'b1111000;
      4'h8:    seg_out <= 7'b0000000;
      4'h9:    seg_out <= 7'b0010000;
      4'hA:    seg_out <= 7'b0001000;
      4'hB:    seg_out <= 7'b0000011;
      4'hC:    seg_out <= 7'b1000110;
      4'hD:    seg_out <= 7'b0100001;
      4'hE:    seg_out <= 7'b0000110;
      4'hF:    seg_out <= 7'b0001110;
      default: seg_out <= 7'b1111111;
   endcase
end


endmodule



// Décodeur 7 segments
// Entrée binaire bit_in sur 1 bits
// Sortie seg_out sur 7 bits

module bin_seg_dec(
                    input bit_in,
                    output reg [6:0]seg_out
                    );

always @(bit_in)
begin
   case (bit_in)
     //                 bit: 6543210
      0:       seg_out <= 7'b1000000;
      1:       seg_out <= 7'b1111001;
      default: seg_out <= 7'b1111111;
   endcase
end
endmodule

// Décodeur 7 segments Empty/Full
// pour la fifo
// Sortie seg_out sur 7 bits

module FE_dec(
               input  full,
               input  empty,
               output reg [6:0] seg_out
             );

always @(*)
begin
   case ({full,empty})
     //                 bit: 6543210
      2'b01:   seg_out <= 7'b0000110;
      2'b10:   seg_out <= 7'b0001110;
      default: seg_out <= 7'b1000000;
   endcase
end


endmodule
