# @file  src.mk
# @brief The source files to loaded in Quartus and modelsim
# @note  This file can be edited by the user to adapt it to its project

export TOP_DIR = $(shell pwd)

export VSIMLIB = $(TOP_DIR)/../top_lib

# rpertoires des fichiers sources
SRC_DIR  := $(TOP_DIR)/src
SRC_FIFO := $(TOP_DIR)/../fifo/src
SRC_MULT := $(TOP_DIR)/../mult/src
SRC_ACCU := $(TOP_DIR)/../accu/src


# Fichier contenant la description de la carte DE2
export TOP_FILE = $(SRC_DIR)/DE1_SoC.v

# Seuls ces fichiers sont simuls
export SYN_SRC = \
$(SRC_FIFO)/fifo.vhd \
$(SRC_MULT)/mult.vhd \
$(SRC_ACCU)/accu.vhd \
$(SRC_DIR)/top.vhd

# Les fichiers qui seront synthtiss
export SOURCE_FILES = $(TOP_FILE) $(SYN_SRC)

# End of SOURCE_FILES
