-------------------------------------------------------------------------------
--                                                                           --
--  FILE          :  TOP_TEST.VHD                                            --
--  Related files :  TOP.VHD                                                 --
--                   TOP_PACK.VHD                                            --
--                                                                           --
--  Author(s)     :  J-L DANGER                                              --
--                                                                           --
--  Project       :  TUTORIEL METHODE                                        --
--                                                                           --
--                                                                           --
--  Description   :  testbench du composant top                              --
--                                                                           --
--  Copyright Tlcom ParisTECH 2012                                         --
--                                                                           --
-------------------------------------------------------------------------------
--  Modifications :                                                          --
-------------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;


use std.textio.all;

--use WORK.TOP_PACK.ALL;

entity TOP_TEST is
end TOP_TEST;


architecture ARCHI of TOP_TEST is

signal  CLK     : std_logic;
signal  N_RESET : std_logic;
signal  WR      : std_logic;
signal  RD      : std_logic;
signal  FULL    : std_logic;
signal  EMPTY   : std_logic;
signal  A       : std_logic_vector(7 downto 0);
signal  B       : std_logic_vector(7 downto 0);
signal  Q       : signed(15 downto 0);
signal  probes  : std_logic_vector(15 downto 0);
file    VECT    : text open READ_MODE is  "./top_test_in.dat";



begin
---------------------------------------------------------------
-- Processus d'horloge
---------------------------------------------------------------
horloge :process
begin
    CLK <='1';
    wait for 50 ns;
    CLK <= '0';
    wait for 50 ns;
end process horloge;

---------------------------------------------------------------
-- Processus du RESET
---------------------------------------------------------------
RESET : process
begin
    N_RESET <= '0';
    wait UNTIL CLK'event and CLK='0';
    N_RESET <= '1';
    wait;
end process RESET;

---------------------------------------------------------------
-- Processus de gnration du "WRITE"
---------------------------------------------------------------
WRITE : process
begin
   RD<='0';
   WR<='0';
   for i in 0 to 10 loop
   WR <= '1';
   wait UNTIL CLK'event and CLK='0';
   end loop;
   WR<='0';
   for i in 0 to 7 loop
   RD <= '1';
   wait UNTIL CLK'event and CLK='0';
   end loop;
   RD <= '0';
   for i in 0 to 10 loop
   wait UNTIL CLK'event and CLK='0';
   end loop;
   for i in 0 to 4 loop
   WR <= '1';
   wait UNTIL CLK'event and CLK='0';
   end loop;
   WR<='0';
   for i in 0 to 7 loop
   RD <= '1';
   wait UNTIL CLK'event and CLK='0';
   end loop;
   RD<='0';

assert(N_RESET='0') report("fin de simulation car fin des impulsions READ/WRITE") severity failure;

end process WRITE;
---------------------------------------------------------------
-- Processus de gnration des donnes  partir d'un fichier
---------------------------------------------------------------
DATA :process
variable L1     : line;
variable A_in   : integer;
variable B_in   : integer;
begin
    loop
        wait until CLK'event and CLK='0';
            if WR='1' then
            readline(VECT,L1);
            read(L1,A_in);
            readline(VECT,L1);
            read(L1,B_in);
            A <= std_logic_vector(to_signed(A_in,8));
            B <= std_logic_vector(to_signed(B_in,8));
            end if;
       assert (ENDFILE(VECT)=FALSE) report "fin de simulation car fin du fichier de vecteurs" severity failure;
    end loop;
end process;

---------------------------------------------------------------
-- instanciation de MEM
---------------------------------------------------------------

INST_TOP : entity WORK.TOP(RTL)
           port map (CLK   => CLK,
                     NRST  => N_RESET,
                     WR    => WR,
                     A     => A,
                     B     => B,
                     Q     => Q,
                     RD    => RD,
                     FULL  => FULL,
                     EMPTY => EMPTY
                    );

end ARCHI;
