-------------------------------------------------------------------------------
--                                                                           --
-- Fichier         : MEM.VHD                                                 --
-- Fichiers utiles : CTR.VHD                                                 --
--                 : + LPM_RAM_DQ et LPM_MULT                                --
--                                                                           --
-- Auteurs         : JLD                                                     --
-- Projet          : PROJET-EXEMPLE                                          --
--                                                                           --
-- Description     : bloc mmoire                                            --
--                                                                           --
--  Copyright Tlcom ParisTECH 2012                                         --
--                                                                           --
-------------------------------------------------------------------------------
-- Modification :                                                            --
-------------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;


entity MULT is
generic
	(
	bits_donnee: integer := 8; 
	mult_pipeline  : integer := 2
	);
port
	(
	CLK		: in	std_logic;
	N_RST	: in	std_logic;
	A		: in	signed(bits_donnee-1 downto 0);
	B		: in	signed(bits_donnee-1 downto 0);
	S		: out	signed(2*bits_donnee-1 downto 0)
	);
end MULT;


architecture BEV of MULT is

type pipe   is array (mult_pipeline-1 downto 0) of signed(2*bits_donnee-1 downto 0);
signal AB                : pipe;


begin

process(CLK,N_RST)
begin
if(N_RST='0') then
	AB <= (others =>(others=>'0'));
elsif (CLK ='1' and CLK'event) then
		AB(0) <= A * B;
     for i in 0 to mult_pipeline-2 loop
	 	AB(i+1) <= AB(i);
	end loop;
end if;
end process;

S <= AB(mult_pipeline-1);

end BEV;


