
library IEEE;
use ieee.std_logic_1164.all;
use IEEE.numeric_std.all;

entity fifo is
  generic(WIDTH : integer := 32;
          DEPTH : integer := 8
          );

  port(clock : in std_logic;
       rst_n : in std_logic;

       -- input Interface              
       wrreq : in     std_logic;
       full  : out std_logic;
       data  : in     std_logic_vector(WIDTH-1 downto 0);

       -- output Interface             
       rdreq : in     std_logic;
       empty : out std_logic;
       q     : out    std_logic_vector(WIDTH-1 downto 0)
       );
end fifo;


architecture bev of fifo is

  type fifo_mem_t is array(DEPTH-1 downto 0) of std_logic_vector(WIDTH-1 downto 0);

  signal fifo_mem : fifo_mem_t;
  signal nb_words : integer range DEPTH downto 0;
  signal wr_ptr   : integer range DEPTH-1 downto 0;
  signal rd_ptr   : integer range DEPTH-1 downto 0;
  signal wr_fifo  : std_logic;
  signal rd_fifo  : std_logic;

  signal full_int,empty_int: std_logic;
 
begin

  full  <= full_int;
  empty <= empty_int;
  full_int  <= '1' when (nb_words = DEPTH) else '0';
  empty_int <= '1' when (nb_words = 0)     else '0';
  wr_fifo <= wrreq when (full_int = '0')   else '0';
  rd_fifo <= rdreq when (empty_int = '0')   else '0';
 

  FIFO_RAM : process(clock, rst_n)
  begin
    if rising_edge(clock) then
      if wr_fifo = '1' then
        fifo_mem(wr_ptr) <= data;
      end if;
      q <= fifo_mem(rd_ptr);
    end if;
  end process FIFO_RAM;


  FIFO_CTR : process (clock, rst_n)
  begin  -- process FSM
    -- reset ASYNCHRONE 
    if rst_n = '0' then
      wr_ptr   <= 0;
      rd_ptr   <= 0;
      nb_words <= 0;
    elsif rising_edge(clock) then

--Ecriture dans la FIFO
      
      if (wr_fifo = '1') then
          if not(rd_fifo = '1') then
            nb_words <= nb_words + 1;
          end if;
          if (wr_ptr = DEPTH-1) then
            wr_ptr <= 0;
          else
            wr_ptr <= wr_ptr + 1;
          end if;
      end if;

-- LECTURE de la fifo

        if (rd_fifo = '1') then
          if not(wr_fifo = '1') then
            nb_words <= nb_words - 1;
          end if;
          if (rd_ptr = DEPTH-1) then
            rd_ptr <= 0;
          else
            rd_ptr <= rd_ptr + 1;
          end if;
        end if;
      end if;

  end process FIFO_CTR;

end bev;


