-------------------------------------------------------------------------------
--                                                                           --
-- Fichier         : ACCU.VHD                                                --
-- Fichiers utiles : GEN_REG.VHD                                             --
--                 : GEN_ADD.VHD                                             --
--                                                                           --
-- Auteurs         : JL DANGER                                               --
-- Projet          : PROJET-EXEMPLE                                          --
--                                                                           --
-- Description     : accumulateur                                            --
--                                                                           --
--  Copyright Télécom ParisTECH 2012                                         --
--                                                                           --
-------------------------------------------------------------------------------
-- Modification :                                                            --
-------------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

--use WORK.ACCU_PACK.all;


entity ACCU is
  generic
    (
      bits_donnee : positive := 8;
      latence     : positive := 2
      );
  port
    (
      CLK  : in  std_logic;
      NRST : in  std_logic;
      EN   : in  std_logic;
      D    : in  signed(bits_donnee-1 downto 0);
      Q    : out signed(bits_donnee-1 downto 0)
      );
end ACCU;

architecture RTL of ACCU is

  signal D_add    : signed(bits_donnee-1 downto 0);
  signal D_clip   : signed(bits_donnee-1 downto 0);
  signal Q_int    : signed(bits_donnee-1 downto 0);
  signal EN_delay : std_logic_vector(latence-1 downto 0);

begin



--Addition

  D_add <=  D + Q_int;



--Saturation
process(D_add,D,Q_int)
	begin
		if (D>=0 and Q_int>=0 and D_add <0) then
			D_clip <= TO_SIGNED(2**(bits_donnee-1)-1,bits_donnee);
		elsif (D<0 and Q_int<0 and D_add>=0) then
			D_clip <= TO_SIGNED(-2**(bits_donnee-1),bits_donnee);
		else
			D_clip <= D_add;
		end if;
	end process;

--  with (std_logic(D_add(bits_donnee-1))& std_logic(Q_int(bits_donnee-1))&std_logic(D(bits_donnee-1))) select
--    D_clip(bits_donnee-1) <=
--    ('0', others => '1')                 when "100",
--    ('1', others => '0')                  when "011",
--    D_add when others;

--  with D_add(bits_donnee downto bits_donnee-1) select
--    D_clip(bits_donnee-2 downto 0) <=
--    (others => '1')               when "01",
--    (others => '0')               when "10",
--    D_add(bits_donnee-2 downto 0) when others;


-- accumulation

  process(CLK, NRST)
  begin
    if (NRST = '0') then
      EN_delay <= (others => '0');
    elsif (CLK'event and CLK = '1') then
      EN_delay(0) <= EN;
      for i in 1 to latence-1 loop
        EN_delay(i) <= EN_delay(i-1);
      end loop;
    end if;
  end process;



  process(CLK, NRST)
  begin
    if NRST = '0' then
      Q_int <= (others => '0');
    elsif rising_edge(CLK) then
      if EN_delay(latence-1) = '1' then
        Q_int <= D_clip;
      end if;
    end if;
  end process;



  Q <= Q_int;

end RTL;
