//*****************************************************************************
//                 Cadence C-to-Silicon Compiler
//
// Copyright notice: Copyright 2006-2012 Cadence Design Systems, Inc. All
// rights reserved worldwide.
//
// The code contained herein is provided to Cadence's customer and may be used
// in accordance with a previously executed license agreement between Cadence
// and that customer. This code is provided as an example for educational
// purposes and is not intended for use in a production design.
//
//*****************************************************************************

#include <systemc.h>
#include <ctos_flex_channels.h>

#include <list>
using std::list;

#include "dut.h"

#ifdef CTOS_MODEL
#include "DUT_ctos_wrapper.h"
#endif


#ifndef TB_HH
#define TB_HH


SC_MODULE(Stimuli) {
    sc_in<bool>         clk;
    sc_in<bool>         nrst;
    b_put_initiator<DT> dout;

    SC_CTOR(Stimuli) 
    {
        SC_THREAD(stimuli);
        sensitive_pos << clk;
        reset_signal_is(nrst,false);
        dout.clk_rst(clk, nrst);
    } 

    list<DT>* req_vals;
    
    void stimuli();
};


SC_MODULE(Monitor) {
    sc_in<bool>         clk;
    sc_in<bool>         nrst;
    b_get_initiator<DT> din;

    SC_CTOR(Monitor) {
        SC_THREAD(monitor);
        sensitive_pos << clk;
        reset_signal_is(nrst,false);
        din.clk_rst(clk, nrst);
    }
    
    list<DT>* req_vals;
    unsigned int cnt;

    void monitor();
};



SC_MODULE(TB) {
    sc_clock            clk;
    sc_signal<bool>     nrst;

#ifdef CTOS_MODEL
    DUT_ctos_wrapper    dut;
#else
    DUT                 dut;
#endif

    Stimuli             stimuli;
    Monitor             monitor;

    put_get_channel<DT> req_chan;
    put_get_channel<DT> rsp_chan;

    bool success;
    list<DT> req_vals;

    SC_CTOR(TB) 
        : clk("clk")
        , nrst("nrst")
#ifdef CTOS_MODEL
        , dut("dut", CTOS_TARGET_SUFFIX(CTOS_MODEL))
#else
        , dut("dut")
#endif
        , stimuli("stimuli")
        , monitor("monitor")
        , req_chan("req_chan")
        , rsp_chan("rsp_chan")
        , success(true)
    {
        SC_THREAD(reset_thread);
        sensitive << clk.posedge_event();

        dut.clk(clk);
        dut.nrst(nrst);

        dut.din(req_chan);
        dut.dout(rsp_chan);

        stimuli.clk(clk);
        stimuli.nrst(nrst);
        stimuli.req_vals = &req_vals;
        stimuli.dout(req_chan);

        monitor.clk(clk);
        monitor.nrst(nrst);
        monitor.req_vals = &req_vals;
        monitor.din(rsp_chan);
    }

    void reset_thread() {
        nrst = 0;
        wait(5);
        nrst = 1;
        sc_event e; 
        wait(e); // wait forever.
    }
};

#endif

