//*****************************************************************************
//                 Cadence C-to-Silicon Compiler
//
// Copyright notice: Copyright 2006-2012 Cadence Design Systems, Inc. All
// rights reserved worldwide.
//
// The code contained herein is provided to Cadence's customer and may be used
// in accordance with a previously executed license agreement between Cadence
// and that customer. This code is provided as an example for educational
// purposes and is not intended for use in a production design.
//
//*****************************************************************************

#include "tb.h"
#include "fun.h"

#define LOG(x) cout << "(" << sc_time_stamp() << ") " << name() << ": " << x << endl;

#define RANDOMIZE_INPUTS 1
#define RANDOMIZE_OUTPUTS 1


void Stimuli::stimuli() {
    dout.reset_put();
    wait();
    while (1) {
#ifdef RANDOMIZE_INPUTS
        if (!(rand()%12)) {
            LOG("stalling inputs...");
            while (!(rand()%6)) wait();
        }
#endif
        DT req;
        req.range( 31,  0) = rand();
        req.range( 63, 32) = rand();
        req.range( 95, 64) = rand();
        req.range(127, 96) = rand();
        dout.put(req);
        req_vals->push_back(req);
    } 
}


void Monitor::monitor() {
    din.reset_get();
    cnt = 0;
    wait();
    while (1) {
#ifdef RANDOMIZE_OUTPUTS
        if (!(rand()%12)) {
            LOG("stalling outputs...");
            while (!(rand()%6)) wait();
        }
#endif
        DT rsp = din.get();
        sc_assert(!req_vals->empty());
        DT req = req_vals->front();
        DT req2 = req;
        req_vals->pop_front();

        // Generating the value from the reference model (C function). 
        int x,y,z,w;

        fun(req2.range(31, 0).to_int(), req2.range( 63,32).to_int(), 
            req2.range(95,64).to_int(), req2.range(127,96).to_int(),
            &x, &y, &z, &w);

        req2.range( 31, 0) = x;
        req2.range( 63,32) = y;
        req2.range( 95,64) = z;
        req2.range(127,96) = w;

        // Compare to see if we got the expected value
        //LOG("expecting req2=" << req2);
        if (!(req2==rsp)) {
            LOG("ERROR:\n\treq=" << req << "\n\tREF=" << req2 << \
                "\n\tDUT=" << rsp << "\n\tcnt=" << cnt);
        }
        sc_assert(req2 == rsp);
        cnt++;
        if (cnt>200000) sc_stop();
    }
}

