//*****************************************************************************
//                 Cadence C-to-Silicon Compiler
//
// Copyright notice: Copyright 2006-2012 Cadence Design Systems, Inc. All
// rights reserved worldwide.
//
// The code contained herein is provided to Cadence's customer and may be used
// in accordance with a previously executed license agreement between Cadence
// and that customer. This code is provided as an example for educational
// purposes and is not intended for use in a production design.
//
//*****************************************************************************

#include <systemc.h>
#include "tb.h"


int sc_main(int argc, char** argv) {
    cout << "test starting..." << endl;
    TB tb("tb");
    cout << "testbench constructed..." << endl;

    // Normal behavior.
    sc_start(100);

    cout << "(" << sc_time_stamp() << "): simulation finished." << endl;
    cout << "Monitor got " << tb.monitor.cnt << " responses." << endl;
    sc_assert(tb.success);
    cout << "PASS: Simulation completed." << endl;

    return 0;

}

