//*****************************************************************************
//                 Cadence C-to-Silicon Compiler
//
// Copyright notice: Copyright 2006-2012 Cadence Design Systems, Inc. All
// rights reserved worldwide.
//
// The code contained herein is provided to Cadence's customer and may be used
// in accordance with a previously executed license agreement between Cadence
// and that customer. This code is provided as an example for educational
// purposes and is not intended for use in a production design.
//
//*****************************************************************************


#include <systemc.h>
#include <ctos_flex_channels.h>


#ifndef DUT_HH
#define DUT_HH

typedef sc_biguint<128> DT;

// ----------------------------------------------------
// SystemC DUT module wrapping the C function.
//
SC_MODULE(DUT) {
    sc_in<bool>         clk;
    sc_in<bool>         nrst;
    get_initiator<DT>   din;
    put_initiator<DT>   dout;

    SC_CTOR(DUT)
        : clk("clk")
        , nrst("nrst")
        , din("din")
        , dout("dout")
    {
        SC_THREAD(process);
        sensitive << clk.pos();
        reset_signal_is(nrst, false);

        din.clk_rst(clk, nrst);
        dout.clk_rst(clk, nrst);
    }

    void process();
};


#endif

