//*****************************************************************************
//                 Cadence C-to-Silicon Compiler
//
// Copyright notice: Copyright 2006-2012 Cadence Design Systems, Inc. All
// rights reserved worldwide.
//
// The code contained herein is provided to Cadence's customer and may be used
// in accordance with a previously executed license agreement between Cadence
// and that customer. This code is provided as an example for educational
// purposes and is not intended for use in a production design.
//
//*****************************************************************************

#include "dut.h"
#include "fun.h"


void DUT::process() {
    din.reset_get();
    dout.reset_put();
    wait();

    PROCESS_LOOP: 
    while (1) {
        DT v = din.get();       // read inputs.

        // Convert types for data inputs: 
        int x_i = v.range( 31, 0).to_int();
        int y_i = v.range( 63,32).to_int();
        int z_i = v.range( 95,64).to_int();
        int w_i = v.range(127,96).to_int();

        int x_o,y_o,z_o,w_o;    // for fun outputs

        // Call the C function here (compute).
        fun( x_i,  y_i,  z_i,  w_i, 
            &x_o, &y_o, &z_o, &w_o);

        // Convert types for data outputs: 
        v.range( 31, 0) = x_o;
        v.range( 63,32) = y_o;
        v.range( 95,64) = z_o;
        v.range(127,96) = w_o;

        dout.put(v);            // write outputs
        wait();
    }
}


#ifdef __CTOS__
SC_MODULE_EXPORT(DUT);
#endif


