#*****************************************************************************
#                 Cadence C-to-Silicon Compiler
# 
# Copyright notice: Copyright 2006-2012 Cadence Design Systems, Inc. All
# rights reserved worldwide.
#
# The code contained herein is provided to Cadence's customer and may be used 
# in accordance with a previously executed license agreement between Cadence 
# and that customer. This code is provided as an example for educational 
# purposes and is not intended for use in a production design.
#
#*******************************************************************************

# *********************
# *       Setup       *
# *********************
if {[get_design] != ""} {
    close_design
}

new_design DUT
  
set_attr design_dir "DUT" [get_design]
set_attr source_files {src/dut.cpp src/fun.cpp} [get_design]
set_attr top_module_path "DUT" [get_design]
set_attr compile_flags " -w  -Isrc " [get_design]

set_attr tech_lib_names "tutorial.lib" [get_design]

set frequency 200
set period [ expr 1000000 / $frequency ]
puts "clock frequency is $frequency - period is $period"
define_clock -name clk -period $period -rise 0 -fall [ expr $period / 2 ]

set_attr enable_multiple_pipeline_stalls true [get_design]

build


# *********************
# * Microarchitecture *
# *********************
inline [find -behavior fun]

pipeline_loop \
    -init_interval 1 -latency {2 100} \
    -expand_before [flex_channels_nets dout] \
    [find -node PROCESS_LOOP_while_begin]


# *********************
# *    Synthesis      *
# *********************
schedule
allocate_registers


# *********************
# * Model Generation  *
# *********************
write_rtl -file ./model/DUT_rtl.v


# ******************************************
# * Create Scripts to run Logic Synthesis  *
# ******************************************
exec mkdir -p run_synth_gates
define_synth_config -run_dir run_synth_gates
write_rc_run_script
write_synth_makefile -overwrite -name run_synth_gates/Makefile.synth
