% Load cipher texts and power traces
load 'data/parsed_cipher_0cm.mat'; % ciph_dec;
load 'data/tab_Obs_0cm.mat';       % tab_Obs;
addpath './common' -end;

% truncate measurements
n_measures = 1000
tab_Obs = tab_Obs(1:n_measures,:);
ciph_dec = ciph_dec(1:n_measures,:);

% exectue analysis
sbox_n = 2
mat_cpa=cpa(sbox_n, tab_Obs, ciph_dec);

% find the right key
[correlation,key]=max(max(abs(mat_cpa)))

% display correlation curves
figure;
axis([0,3003,-.3,+.3]);
plot(mat_cpa);
