function bitvector = int2bin( i, n )
% Turns an integer into a bitvector. Assuming the left-hand bit to be the MSB.
% Exemple:
% int2bin( [10;1], 4 ) => [1 0 1 0; 0 0 0 1]
bitvector = zeros( size( i, 1 ), n );
for bit = 1:size( bitvector, 2 )
	bitvector( :, n+1-bit ) = bitand( i, 1 );
	i = bitshift( i, -1 );
end
