function bin = hex2bin( hex )
% convert from hexadecimal notation to binary
% hex is expected to be a vector, of size [nb_words nb_bits].
%
% Example:
% >> hex2bin( '12af' )
%    0 0 0 1 0 0 1 0 1 0 1 0 1 1 1 1
%
% This is very useful for DES plaintext / ciphertext conversion from textual notation to internal representation.

bin = zeros( size( hex, 1 ), 4*size( hex, 2 ) ); % One hexadecimal character encodes four bits

% TODO: PARALLELIZE
for row = 1:size( hex, 1 )
for i   = 1:size( hex, 2 )
	nibble = hex2dec( hex(row,i) );
	for j = 0 : 3
		bin( row, 4*(i-1)+j+1 ) = bitand( 1, bitshift( nibble, j-3 ));
	end;
end;
end
