function i = bin2int( bitvector )
% Turns a bitvector into an integer. Assuming the left-hand bit to be the MSB.
% Exemple:
% bin2int( [1 0 1 0; 0 0 0 1] ) => [10;1]
i = zeros( size( bitvector, 1 ), 1 );
power = 1; % Successive powers of two
for bit = size( bitvector, 2 ):-1:1
	i = i + power * bitvector( :,bit );
	power = power * 2;
end
