function hex = bin2hex( bin )
% convert from binary notation to hexadecimal
% bin is expected to be a matrix, of size [nb_string nb_bits], with nb_bits being a multiple of four.
%
% Examples:
% >> bin2hex( [0 0 0 1 0 0 1 0 1 0 1 0 1 1 1 1] )
%    '12af'
% >> bin2hex( [0 0 0 1 0 0 1 0 1 0 1 0 1 1 1 1; 1 0 0 1 0 0 1 0 1 0 1 0 1 1 1 1] )
%    '12af'
%    '92af'
%
% This is very useful for DES plaintext / ciphertext conversion from internal representation to textual notation.
if rem( size( bin, 2 ), 4 ) ~= 0
	error( ['Bad dimension for the input: the expect a binary vector to be converted in hexa to have a multiple of 4 bits, ' ...
	        'but here it is ' int2str( size( bin, 2 )) ] )
end

hex = zeros( size( bin, 1), size( bin, 2 )/4 );
% TODO: PARALLELIZE
% TODO: bin2dec already exists and is surely faster, but it is limited to 36-bit figures

for row = 1:size( bin, 1 )
	for i = 1:size( bin, 2 )/4
		nibble = 0;
		for j = 0 : 3
			nibble = nibble * 2; % No operator "*=" in Matlab?
			bit = bin( row, 4*(i-1)+j+1 );
			if bit ~= 0 && bit ~= 1
				error( ['Bad bit value in bin2hex( bin )=[' int2str( bit ) '] at i=' int2str( i ) ' and j=' int2str( j ) ] )
			end
			nibble = nibble + bit; % +0 or +1
		end;
		hex( row, i ) = dec2hex( nibble );
	end;
end
hex = lower( char( hex )); % I prefer when hexadecimal figures are printed lowercase
