function STATE=aes(bin_k,bin_m,bin_cip)

if size(bin_k)~=128 
    error( ['Bad dimension for the key: the expect a binary vector of 128 bits'] )
end

if size(bin_m)~=128
    error( ['Bad dimension for the message: the expect a binary vector of 128 bits'] )
end

if size(bin_cip)~=128
    error( ['Bad dimension for the cipher: the expect a binary vector of 128 bits'] )
end

STATE=zeros(11,128);
%Key Expansion
K=KeyExpansion(bin_k);

for i=1:11
    %Addroundkey 1
    if i==1
        state = xor(K(1,:),bin_m);
        STATE(1,:)=state;
    else
        %SubByte 1
        state=SubBytes(state);
        %ShiftRows1
        state=ShiftRows(state,'cipher');        
        if i<11
            %MixColumns
            state=MixColumns(state);    
        end
        state=xor(state,K(i,:));
        STATE(i,:)=state;
    end
end