// --------------------------------------------------------------------
// Copyright (c) 2005 by Terasic Technologies Inc.
// --------------------------------------------------------------------
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// --------------------------------------------------------------------
//
//                     Terasic Technologies Inc
//                     356 Fu-Shin E. Rd Sec. 1. JhuBei City,
//                     HsinChu County, Taiwan
//                     302
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// --------------------------------------------------------------------
//
// Major Functions:    DE2 TOP LEVEL
//
// --------------------------------------------------------------------
//
// Revision History :
// --------------------------------------------------------------------
//   Ver  :| Author            :| Mod. Date :| Changes Made:
//   V1.0 :| Johnny Chen       :| 05/08/19  :| Initial Revision
//   V1.1 :| Johnny Chen       :| 05/11/16  :| Added FLASH Address fl_addr[21:20]
//   V1.2 :| Johnny Chen       :| 05/11/16  :| Fixed ISP1362 INT/DREQ Pin Direction.
//   V1.3 :| Johnny Chen       :| 05/11/16  :| Added the Dedicated TV Decoder Line-Locked-Clock Input
//                                             for DE2 v2.X PCB.
//   Modif T.G/Y.M./A.P Telecom ParisTECH
// --------------------------------------------------------------------

`default_nettype none

module de2_top
    (
        ////////////////////    Clock Input         ////////////////////
        clock_27,                        //    27 MHz
        clock_50,                        //    50 MHz
        ext_clock,                       //    External Clock
        ////////////////////    Push Button        ////////////////////
        key,                             //    Pushbutton[3:0]
        ////////////////////    DPDT Switch        ////////////////////
        sw,                              //    Toggle Switch[17:0]
        ////////////////////    7-SEG Dispaly    ////////////////////
        hex0,                            //    Seven Segment Digit 0
        hex1,                            //    Seven Segment Digit 1
        hex2,                            //    Seven Segment Digit 2
        hex3,                            //    Seven Segment Digit 3
        hex4,                            //    Seven Segment Digit 4
        hex5,                            //    Seven Segment Digit 5
        hex6,                            //    Seven Segment Digit 6
        hex7,                            //    Seven Segment Digit 7
        ////////////////////////    LED        ////////////////////////
        ledg,                            //    LED Green[8:0]
        ledr,                            //    LED Red[17:0]
        ////////////////////////    UART    ////////////////////////
        uart_txd,                        //    UART Transmitter
        uart_rxd,                        //    UART Receiver
        ////////////////////////    IRDA    ////////////////////////
        irda_txd,                        //    IRDA Transmitter
        irda_rxd,                        //    IRDA Receiver
        /////////////////////    SDRAM Interface        ////////////////
        dram_dq,                         //    SDRAM Data bus 16 Bits
        dram_addr,                       //    SDRAM Address bus 12 Bits
        dram_ldqm,                       //    SDRAM Low-byte Data Mask
        dram_udqm,                       //    SDRAM High-byte Data Mask
        dram_we_n,                       //    SDRAM Write Enable
        dram_cas_n,                      //    SDRAM Column Address Strobe
        dram_ras_n,                      //    SDRAM Row Address Strobe
        dram_cs_n,                       //    SDRAM Chip Select
        dram_ba_0,                       //    SDRAM Bank Address 0
        dram_ba_1,                       //    SDRAM Bank Address 0
        dram_clk,                        //    SDRAM Clock
        dram_cke,                        //    SDRAM Clock Enable
        ////////////////////    Flash Interface        ////////////////
        fl_dq,                           //    FLASH Data bus 8 Bits
        fl_addr,                         //    FLASH Address bus 22 Bits
        fl_we_n,                         //    FLASH Write Enable
        fl_rst_n,                        //    FLASH Reset
        fl_oe_n,                         //    FLASH Output Enable
        fl_ce_n,                         //    FLASH Chip Enable
        ////////////////////    SRAM Interface        ////////////////
        sram_dq,                         //    SRAM Data bus 16 Bits
        sram_addr,                       //    SRAM Address bus 18 Bits
        sram_ub_n,                       //    SRAM High-byte Data Mask
        sram_lb_n,                       //    SRAM Low-byte Data Mask
        sram_we_n,                       //    SRAM Write Enable
        sram_ce_n,                       //    SRAM Chip Enable
        sram_oe_n,                       //    SRAM Output Enable
        ////////////////////    ISP1362 Interface    ////////////////
        otg_data,                        //    ISP1362 Data bus 16 Bits
        otg_addr,                        //    ISP1362 Address 2 Bits
        otg_cs_n,                        //    ISP1362 Chip Select
        otg_rd_n,                        //    ISP1362 Write
        otg_wr_n,                        //    ISP1362 Read
        otg_rst_n,                       //    ISP1362 Reset
        otg_fspeed,                      //    USB Full Speed,    0 = Enable, Z = Disable
        otg_lspeed,                      //    USB Low Speed,     0 = Enable, Z = Disable
        otg_int0,                        //    ISP1362 Interrupt 0
        otg_int1,                        //    ISP1362 Interrupt 1
        otg_dreq0,                       //    ISP1362 DMA Request 0
        otg_dreq1,                       //    ISP1362 DMA Request 1
        otg_dack0_n,                     //    ISP1362 DMA Acknowledge 0
        otg_dack1_n,                     //    ISP1362 DMA Acknowledge 1
        ////////////////////    LCD Module 16X2        ////////////////
        lcd_on,                          //    LCD Power ON/OFF
        lcd_blon,                        //    LCD Back Light ON/OFF
        lcd_rw,                          //    LCD Read/Write Select, 0 = Write, 1 = Read
        lcd_en,                          //    LCD Enable
        lcd_rs,                          //    LCD Command/Data Select, 0 = Command, 1 = Data
        lcd_data,                        //    LCD Data bus 8 bits
        ////////////////////    sd_card Interface    ////////////////
        sd_dat,                          //    SD Card Data
        sd_dat3,                         //    SD Card Data 3
        sd_cmd,                          //    SD Card Command Signal
        sd_clk,                          //    SD Card Clock
        ////////////////////    USB JTAG link    ////////////////////
        tdi,                             // CPLD -> FPGA (data in)
        tck,                             // CPLD -> FPGA (clk)
        tcs,                             // CPLD -> FPGA (CS)
        tdo,                             // FPGA -> CPLD (data out)
        ////////////////////    I2C        ////////////////////////////
        i2c_sdat,                        //    I2C Data
        i2c_sclk,                        //    I2C Clock
        ////////////////////    PS2        ////////////////////////////
        ps2_dat,                         //    PS2 Data
        ps2_clk,                         //    PS2 Clock
        ////////////////////    VGA        ////////////////////////////
        vga_clk,                         //    VGA Clock
        vga_hs,                          //    VGA H_SYNC
        vga_vs,                          //    VGA V_SYNC
        vga_blank,                       //    VGA BLANK
        vga_sync,                        //    VGA SYNC
        vga_r,                           //    VGA Red[9:0]
        vga_g,                           //    VGA Green[9:0]
        vga_b,                           //    VGA Blue[9:0]
        ////////////    Ethernet Interface    ////////////////////////
        enet_data,                       //    DM9000A DATA bus 16Bits
        enet_cmd,                        //    DM9000A Command/Data Select, 0 = Command, 1 = Data
        enet_cs_n,                       //    DM9000A Chip Select
        enet_wr_n,                       //    DM9000A Write
        enet_rd_n,                       //    DM9000A Read
        enet_rst_n,                      //    DM9000A Reset
        enet_int,                        //    DM9000A Interrupt
        enet_clk,                        //    DM9000A Clock 25 MHz
        ////////////////    Audio CODEC        ////////////////////////
        aud_adclrck,                     //    Audio CODEC ADC LR Clock
        aud_adcdat,                      //    Audio CODEC ADC Data
        aud_daclrck,                     //    Audio CODEC DAC LR Clock
        aud_dacdat,                      //    Audio CODEC DAC Data
        aud_bclk,                        //    Audio CODEC Bit-Stream Clock
        aud_xck,                         //    Audio CODEC Chip Clock
        ////////////////    TV Decoder        ////////////////////////
        td_data,                         //    TV Decoder Data bus 8 bits
        td_hs,                           //    TV Decoder H_SYNC
        td_vs,                           //    TV Decoder V_SYNC
        td_reset,                        //    TV Decoder Reset
        td_clk,                          //    TV Decoder Clock
        ////////////////////    GPIO    ////////////////////////////
        gpio_0,                          //    GPIO Connection 0
        gpio_1                           //    GPIO Connection 1
    );

////////////////////////    Clock Input         //////////////////////
input wire             clock_27;        //    27 MHz
input wire             clock_50;        //    50 MHz
input wire             ext_clock;       //    External Clock
////////////////////////    Push Button        ///////////////////////
input wire    [3:0]    key;             //    Pushbutton[3:0]
////////////////////////    DPDT Switch        ///////////////////////
input wire    [17:0]   sw;              //    Toggle Switch[17:0]
////////////////////////    7-SEG Dispaly    /////////////////////////
output logic  [6:0]    hex0;            //    Seven Segment Digit 0
output logic  [6:0]    hex1;            //    Seven Segment Digit 1
output logic  [6:0]    hex2;            //    Seven Segment Digit 2
output logic  [6:0]    hex3;            //    Seven Segment Digit 3
output logic  [6:0]    hex4;            //    Seven Segment Digit 4
output logic  [6:0]    hex5;            //    Seven Segment Digit 5
output logic  [6:0]    hex6;            //    Seven Segment Digit 6
output logic  [6:0]    hex7;            //    Seven Segment Digit 7
////////////////////////////    LED        ///////////////////////////
output logic  [8:0]    ledg;            //    LED Green[8:0]
output logic  [17:0]   ledr;            //    LED Red[17:0]
////////////////////////////    UART    /////////////////////////////
output logic           uart_txd;        //    UART Transmitter
input wire             uart_rxd;        //    UART Receiver
////////////////////////////    IRDA    //////////////////////////////
output logic           irda_txd;        //    IRDA Transmitter
input wire             irda_rxd;        //    IRDA Receiver
///////////////////////        SDRAM Interface    ////////////////////
inout wire    [15:0]   dram_dq;         //    SDRAM Data bus 16 Bits
output logic  [11:0]   dram_addr;       //    SDRAM Address bus 12 Bits
output logic           dram_ldqm;       //    SDRAM Low-byte Data Mask
output logic           dram_udqm;       //    SDRAM High-byte Data Mask
output logic           dram_we_n;       //    SDRAM Write Enable
output logic           dram_cas_n;      //    SDRAM Column Address Strobe
output logic           dram_ras_n;      //    SDRAM Row Address Strobe
output logic           dram_cs_n;       //    SDRAM Chip Select
output logic           dram_ba_0;       //    SDRAM Bank Address 0
output logic           dram_ba_1;       //    SDRAM Bank Address 0
output logic           dram_clk;        //    SDRAM Clock
output logic           dram_cke;        //    SDRAM Clock Enable
////////////////////////    Flash Interface    ///////////////////////
inout wire    [7:0]    fl_dq;           //    FLASH Data bus 8 Bits
output logic  [21:0]   fl_addr;         //    FLASH Address bus 22 Bits
output logic           fl_we_n;         //    FLASH Write Enable
output logic           fl_rst_n;        //    FLASH Reset
output logic           fl_oe_n;         //    FLASH Output Enable
output logic           fl_ce_n;         //    FLASH Chip Enable
////////////////////////    SRAM Interface    ////////////////////////
inout wire    [15:0]   sram_dq;         //    SRAM Data bus 16 Bits
output logic  [17:0]   sram_addr;       //    SRAM Address bus 18 Bits
output logic           sram_ub_n;       //    SRAM High-byte Data Mask
output logic           sram_lb_n;       //    SRAM Low-byte Data Mask
output logic           sram_we_n;       //    SRAM Write Enable
output logic           sram_ce_n;       //    SRAM Chip Enable
output logic           sram_oe_n;       //    SRAM Output Enable
////////////////////    ISP1362 Interface    /////////////////////////
inout wire    [15:0]   otg_data;        //    ISP1362 Data bus 16 Bits
output logic  [1:0]    otg_addr;        //    ISP1362 Address 2 Bits
output logic           otg_cs_n;        //    ISP1362 Chip Select
output logic           otg_rd_n;        //    ISP1362 Write
output logic           otg_wr_n;        //    ISP1362 Read
output logic           otg_rst_n;       //    ISP1362 Reset
output logic           otg_fspeed;      //    USB Full Speed,    0 = Enable, Z = Disable
output logic           otg_lspeed;      //    USB Low Speed,     0 = Enable, Z = Disable
input wire             otg_int0;        //    ISP1362 Interrupt 0
input wire             otg_int1;        //    ISP1362 Interrupt 1
input wire             otg_dreq0;       //    ISP1362 DMA Request 0
input wire             otg_dreq1;       //    ISP1362 DMA Request 1
output logic           otg_dack0_n;     //    ISP1362 DMA Acknowledge 0
output logic           otg_dack1_n;     //    ISP1362 DMA Acknowledge 1
////////////////////    LCD Module 16X2    ///////////////////////////
output logic  [7:0]    lcd_data;        //    LCD Data bus 8 bits
output logic           lcd_on;          //    LCD Power ON/OFF
output logic           lcd_blon;        //    LCD Back Light ON/OFF
output logic           lcd_rw;          //    LCD Read/Write Select, 0 = Write, 1 = Read
output logic           lcd_en;          //    LCD Enable
output logic           lcd_rs;          //    LCD Command/Data Select, 0 = Command, 1 = Data
////////////////////    SD Card Interface    /////////////////////////
inout wire             sd_dat;          //    SD Card Data
inout wire             sd_dat3;         //    SD Card Data 3
inout wire             sd_cmd;          //    SD Card Command Signal
output logic           sd_clk;          //    SD Card Clock
////////////////////////    I2C        ///////////////////////////////
inout wire             i2c_sdat;        //    I2C Data
output logic           i2c_sclk;        //    I2C Clock
////////////////////////    PS2        ///////////////////////////////
input wire             ps2_dat;         //    PS2 Data
input wire             ps2_clk;         //    PS2 Clock
////////////////////    USB JTAG link    /////////////////////////////
input wire             tdi;             // CPLD -> FPGA (data in)
input wire             tck;             // CPLD -> FPGA (clk)
input wire             tcs;             // CPLD -> FPGA (CS)
output logic           tdo;             // FPGA -> CPLD (data out)
////////////////////////    VGA            ///////////////////////////
output logic           vga_clk;         //    VGA Clock
output logic           vga_hs;          //    VGA H_SYNC
output logic           vga_vs;          //    VGA V_SYNC
output logic           vga_blank;       //    VGA BLANK
output logic           vga_sync;        //    VGA SYNC
output logic  [9:0]    vga_r;           //    VGA Red[9:0]
output logic  [9:0]    vga_g;           //    VGA Green[9:0]
output logic  [9:0]    vga_b;           //    VGA Blue[9:0]
////////////////    Ethernet Interface    ////////////////////////////
inout wire    [15:0]    enet_data;      //    DM9000A DATA bus 16Bits
output logic           enet_cmd;        //    DM9000A Command/Data Select, 0 = Command, 1 = Data
output logic           enet_cs_n;       //    DM9000A Chip Select
output logic           enet_wr_n;       //    DM9000A Write
output logic           enet_rd_n;       //    DM9000A Read
output logic           enet_rst_n;      //    DM9000A Reset
input wire             enet_int;        //    DM9000A Interrupt
output logic           enet_clk;        //    DM9000A Clock 25 MHz
////////////////////    Audio CODEC        ///////////////////////////
inout wire             aud_adclrck;     //    Audio CODEC ADC LR Clock
input wire             aud_adcdat;      //    Audio CODEC ADC Data
inout wire             aud_daclrck;     //    Audio CODEC DAC LR Clock
output logic           aud_dacdat;      //    Audio CODEC DAC Data
inout wire             aud_bclk;        //    Audio CODEC Bit-Stream Clock
output logic           aud_xck;         //    Audio CODEC Chip Clock
////////////////////    TV Devoder        ////////////////////////////
input wire    [7:0]    td_data;         //    TV Decoder Data bus 8 bits
input wire             td_hs;           //    TV Decoder H_SYNC
input wire             td_vs;           //    TV Decoder V_SYNC
output logic           td_reset;        //    TV Decoder Reset
input wire             td_clk;          //    TV Decoder Clock
////////////////////////    GPIO    /////////////////////////////////
inout wire    [35:0]   gpio_0;          //    GPIO Connection 0
inout wire    [35:0]   gpio_1;          //    GPIO Connection 1

//    Turn off all display     //////////////////////////////////////
assign    hex0        =    7'h7F;
assign    hex1        =    7'h7F;
assign    hex2        =    7'h7F;
assign    hex3        =    7'h7F;
assign    hex4        =    7'h7F;
assign    hex5        =    7'h7F;
assign    hex6        =    7'h7F;
assign    hex7        =    7'h7F;
//assign    ledg        =    9'h000;
assign    ledr        =    18'h00000;

// Reset pour du systeme utilisant key[0]
wire async_reset = ~key[0];
// Resynchronisation du reset sur l'horloge
// Les attributs de synthèse servent à enmpêcher l'optimisation
logic reset   /* synthesis ALTERA_ATTRIBUTE = "{-from \"*\"} CUT=ON ; PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101"  */ ;
logic reset_r /* synthesis ALTERA_ATTRIBUTE = "PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101"  */; 

always @(posedge clock_50 or posedge async_reset)
if (async_reset)
begin
  reset_r <= 1'b1;
  reset <= 1'b1 ;
end
else
begin
  reset_r <= 1'b0 ;
  reset <= reset_r ;
end

// reset negatif (au cas où)
wire nreset = ~reset;

//detecteur de fronts
logic [1:0] bb1;
logic fr_mt_k3 ;
always  @(posedge clock_50)
  begin
    bb1 <= {bb1[0],key[3]};
    fr_mt_k3 <=  bb1[1] & !bb1[0];
  end

// L'horloge à 25 Mhz
logic clock_25 ;
always  @(posedge clock_50 or posedge reset)
  if(reset)
    clock_25 <= 1'b0 ;
  else
    clock_25 <= !clock_25  ;


// LCD : Display Welcome Banner     /////////////////////////////////
assign    lcd_on      =    1'b1;
assign    lcd_blon    =    1'b1;
lcd_tpt  lcd_tpt_i 
          (//      Host Side
              .iCLK(clock_50),
              .iRST_N(nreset),
              //      LCD Side
              .lcd_data(lcd_data),
              .lcd_rw(lcd_rw),
              .lcd_en(lcd_en),
              .lcd_rs(lcd_rs)
          );

/////////////////////////////////////////////////////////////////////
//         Video VGA     ////////////////////////////////////////////

wire [9:0] x;
wire [9:0] y;
wire pixel_valid ;
wire first_line;
wire first_pixel;
wire [7:0] ri;
wire [7:0] gi;
wire [7:0] bi;
wire eof;

//////////////////////////////////////////////////////////////////////
/////  Le controle des signaux  VGA///////////////////////////////////
//////////////////////////////////////////////////////////////////////
vga vga_i (	.clk      (clock_25),
			.nrst     (nreset),
            .x        (x),
            .y        (y),
            .pixel_valid   (pixel_valid),
            .first_line  (first_line),
            .first_pixel (first_pixel),
            .r        (ri),
            .g        (gi),
            .b        (bi),
            .eof      (eof),
			.vga_hsync(vga_hs),
			.vga_vsync(vga_vs),
			.vga_clk  (vga_clk),
			.vga_blank(vga_blank),
			.vga_sync (vga_sync),
			.vga_r    (vga_r),
			.vga_g    (vga_g),
			.vga_b    (vga_b)
			);

// Le générateur d'images
wire [7:0] pixel_uncompress ;
wire [7:0] pixel_scrambled ;
wire [7:0] pixel_descrambled ;
wire [7:0] pixel_mire ;
wire [7:0] pixel_ref ;
wire [7:0] pixel ;
wire [1:0] retard,retard_officiel,retard_pirate,retard_pirate_de_luxe ;

// La sortie video est N&B
assign ri = pixel ;
assign gi = pixel ;
assign bi = pixel ;

//////////////////////////////////////////////////////////////////////
/////  La selection des modes et signaux /////////////////////////////
//////////////////////////////////////////////////////////////////////

// Choix de la nature l'image:
// sw[17] = 1 : big buck bunny
// sw[17] = 0 : mire 
assign pixel_ref = sw[17] ? pixel_uncompress : pixel_mire ;

// Le choix de la sortie :
// sw[1] = 0 , sw[0] = 0 : l'image de base
// sw[1] = 0 , sw[0] = 1 : l'image brouillée
// sw[1] = 1 : l'image désembrouillée...
always_comb
  case ({sw[1],sw[0]})
    2'b00 : pixel <= pixel_ref ;
    2'b01 : pixel <= pixel_scrambled ;
    default : pixel <= pixel_descrambled ;
  endcase

// Le choix du type de décodeur 
// sw[14] = 0 : le décodeur "officiel"
// sw[14] = 1 sw[13] = 0 : le décodeur pirate maladroit
// sw[14] = 1 sw[13] = 1 : le décodeur pirate par correlation
always_comb
  case (sw[14:13])
    2'b10 : retard <= retard_pirate ;
    2'b11 : retard <= retard_pirate_de_luxe ;
    default : retard <= retard_officiel ;
  endcase

//////////////////////////////////////////////////////////////////////
/////  Le générateur de big buck bunny////////////////////////////////
//////////////////////////////////////////////////////////////////////

uncompress uncompress_i(.clk(clock_25),
               .pixel_valid(pixel_valid),
               .first_line(first_line),
               .first_pixel(first_pixel),
               .x(x),
               .y(y),
               .pixel(pixel_uncompress)) ;

//////////////////////////////////////////////////////////////////////
/////  Le générateur de mire          ////////////////////////////////
//////////////////////////////////////////////////////////////////////

mire mire_i(.clk(clock_25),
            .pixel_valid(pixel_valid),
            .x(x),
            .y(y),
            .pixel(pixel_mire)) ;

//////////////////////////////////////////////////////////////////////
/////  Le brouillage de l'image        ///////////////////////////////
//////////////////////////////////////////////////////////////////////

scrambler scrambler_i(.clk(clock_25),
                    .nreset(nreset),
                    .x(x),
                    .y(y),
                    .pixel_valid(pixel_valid),
                    .pixel_in(pixel_ref),
                    .pixel_out(pixel_scrambled),
                    .retard(retard_officiel), 
                    .sel(sw[16:15]),
                    .add_noise(sw[14] && sw[13]) 
                   ) ;

//////////////////////////////////////////////////////////////////////
/////  Le désembrouillage de l'image   ///////////////////////////////
//////////////////////////////////////////////////////////////////////

descrambler descrambler_i(.clk(clock_25),
                          .nreset(nreset),
                          .x(x),
                          .y(y),
                          .pixel_valid(pixel_valid),
                          .pixel_in(pixel_scrambled),
                          .pixel_out(pixel_descrambled),
                          .retard(retard),
                          .sel(sw[16:15])
                          ) ;

//////////////////////////////////////////////////////////////////////
/////  La recherche du retard par détection de début de ligne ///////
//////////////////////////////////////////////////////////////////////


cherche_retard cherche_retard_i(.clk(clock_25),
                  .nreset(nreset),
                  .x(x),
                  .y(y),
                  .pixel_valid(pixel_valid),
                  .pixel_in(pixel_scrambled),
                  .retard(retard_pirate)) ;

//////////////////////////////////////////////////////////////////////
/////  La recherche du retard par correlation entre ligne      ///////
//////////////////////////////////////////////////////////////////////

cherche_correlation cherche_correlation_i(.clk(clock_25),
                  .nreset(nreset),
                  .x(x),
                  .y(y),
                  .pixel_valid(pixel_valid),
                  .pixel_in(pixel_scrambled),
                  .retard(retard_pirate_de_luxe)) ;


//////////////////////////////////////////////////////////////////////
// Module pour la gestion du    //////////////////////////////////////
// codec audio                  //////////////////////////////////////

//    (aud_bclk)                // Horloge pour les données
//                              // du CODEC
//    (aud_adcdat)              // Données de l'ADC
//    (aud_adclrck)             // indicateur Gauche/Droite
//                              // pour les données de l'ADC
//    (aud_dacdat)              // Données de le DAC
//    (aud_daclrck)             // indicateur Gauche/Droite
//                      // pour les données de l'ADC

assign aud_adclrck  =  1'bz;
assign aud_daclrck  =  1'bz;
assign aud_bclk     =  1'bz;

// On relie ici la sortie de l'ADC à l'entrée du DAC /////////////////
// Signal série sur 1bit                             /////////////////
wire   donnees_audio;
assign donnees_audio = aud_adcdat;
assign aud_dacdat = donnees_audio;

sound sound_i(
    .clk(clock_50),       // Horloge système
    .nrst(nreset),        // RESET
    .i2c_sclk(i2c_sclk),  // Horloge I2C
    .i2c_sdat(i2c_sdat),  // Données I2C
    .aud_xck(aud_xck)     // Horloge du CODEC
);

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
//    Tous les ports en entrees/sorties mis au 3e etat       /////////
assign    dram_dq   =  16'hzzzz;
assign    fl_dq     =  8'hzz;
assign    sram_dq   =  16'hzzzz;
assign    otg_data  =  16'hzzzz;
assign    sd_dat    =  1'bz;
assign    enet_data =  16'hzzzz;
assign    gpio_0    =  36'hzzzzzzzzz;
assign    gpio_1    =  36'hzzzzzzzzz;
assign    sd_dat    =  1'bz;
assign    sd_dat3   =  1'bz;
assign    sd_cmd    =  1'bz;
//////////////////////////////////////////////////////////////////////

// If you want to have the 27 MHz clock uncomment this line
// assign td_reset = 1'b1;

endmodule
